/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.models.simple;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import opennlp.tools.models.AbstractClassPathModelFinder;
import opennlp.tools.models.ClassPathModelFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleClassPathModelFinder
extends AbstractClassPathModelFinder
implements ClassPathModelFinder {
    private static final Logger logger = LoggerFactory.getLogger(SimpleClassPathModelFinder.class);
    private static final String FILE_PREFIX = "file";
    private static final Pattern CLASSPATH_SEPARATOR_PATTERN_WINDOWS = Pattern.compile(";");
    private static final Pattern CLASSPATH_SEPARATOR_PATTERN_UNIX = Pattern.compile(":");

    public SimpleClassPathModelFinder() {
        this("opennlp-models-*.jar");
    }

    public SimpleClassPathModelFinder(String modelJarPrefix) {
        super(modelJarPrefix);
    }

    @Override
    protected Object getContext() {
        return null;
    }

    @Override
    protected List<URI> getMatchingURIs(String wildcardPattern, Object context) {
        if (wildcardPattern == null) {
            return Collections.emptyList();
        }
        boolean isWindows = this.isWindows();
        List<URL> cp = this.getClassPathElements();
        ArrayList<URI> cpu = new ArrayList<URI>();
        Pattern jarPattern = Pattern.compile(this.asRegex("*" + this.getJarModelPrefix()));
        Pattern filePattern = Pattern.compile(this.asRegex("*" + wildcardPattern));
        for (URL url : cp) {
            if (!this.matchesPattern(url, jarPattern)) continue;
            try {
                for (URI u : this.getURIsFromJar(url, isWindows)) {
                    if (!this.matchesPattern(u.toURL(), filePattern)) continue;
                    cpu.add(u);
                }
            }
            catch (IOException e) {
                logger.warn("Cannot read content of {}.", (Object)url, (Object)e);
            }
        }
        return cpu;
    }

    private String asRegex(String wildcard) {
        return wildcard.replace(".", "\\.").replace("*", ".*").replace("?", ".");
    }

    private boolean matchesPattern(URL url, Pattern pattern) {
        return pattern.matcher(url.getFile()).matches();
    }

    private List<URI> getURIsFromJar(URL fileUrl, boolean isWindows) throws IOException {
        ArrayList<URI> uris = new ArrayList<URI>();
        URL jarUrl = new URL("jar:" + (isWindows ? fileUrl.toString().replace("\\", "/") : fileUrl.toString()) + "!/");
        JarURLConnection jarConnection = (JarURLConnection)jarUrl.openConnection();
        try (JarFile jarFile = jarConnection.getJarFile();){
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (entry.isDirectory()) continue;
                URL entryUrl = new URL(String.valueOf(jarUrl) + entry.getName());
                try {
                    uris.add(entryUrl.toURI());
                }
                catch (URISyntaxException uRISyntaxException) {}
            }
        }
        return uris;
    }

    private boolean isWindows() {
        return System.getProperty("os.name", "unknown").toLowerCase(Locale.ROOT).contains("win");
    }

    private List<URL> getClassPathElements() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl instanceof URLClassLoader) {
            URLClassLoader ucl = (URLClassLoader)cl;
            return Arrays.asList(ucl.getURLs());
        }
        URL[] fromUcp = this.getURLs(cl);
        if (fromUcp != null && fromUcp.length > 0) {
            return Arrays.asList(fromUcp);
        }
        return this.getClassPathUrlsFromSystemProperty();
    }

    private List<URL> getClassPathUrlsFromSystemProperty() {
        String cp = System.getProperty("java.class.path", "");
        String[] matches = this.isWindows() ? CLASSPATH_SEPARATOR_PATTERN_WINDOWS.split(cp) : CLASSPATH_SEPARATOR_PATTERN_UNIX.split(cp);
        ArrayList<URL> jarUrls = new ArrayList<URL>();
        for (String classPath : matches) {
            try {
                jarUrls.add(new URL(FILE_PREFIX, "", classPath));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return jarUrls;
    }

    private URL[] getURLs(ClassLoader classLoader) {
        try {
            Class<?> builtinClazzLoader = Class.forName("jdk.internal.loader.BuiltinClassLoader");
            Field ucpField = builtinClazzLoader.getDeclaredField("ucp");
            ucpField.setAccessible(true);
            Object ucpObject = ucpField.get(classLoader);
            Class<?> clazz = Class.forName("jdk.internal.loader.URLClassPath");
            if (ucpObject != null) {
                Method getURLs = clazz.getMethod("getURLs", new Class[0]);
                return (URL[])getURLs.invoke(ucpObject, new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new URL[0];
    }
}

