/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.lemmatizer;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import opennlp.tools.commons.Sample;

public class LemmaSample
implements Sample {
    private static final long serialVersionUID = -7956607496164605337L;
    private final List<String> tokens;
    private final List<String> tags;
    private final List<String> lemmas;

    public LemmaSample(String[] tokens, String[] tags, String[] lemmas) {
        this(Arrays.asList(tokens), Arrays.asList(tags), Arrays.asList(lemmas));
    }

    public LemmaSample(List<String> tokens, List<String> tags, List<String> lemmas) {
        this.validateArguments(tokens.size(), tags.size(), lemmas.size());
        this.tokens = List.copyOf(tokens);
        this.tags = List.copyOf(tags);
        this.lemmas = List.copyOf(lemmas);
    }

    public String[] getTokens() {
        return this.tokens.toArray(new String[0]);
    }

    public String[] getTags() {
        return this.tags.toArray(new String[0]);
    }

    public String[] getLemmas() {
        return this.lemmas.toArray(new String[0]);
    }

    private void validateArguments(int tokensSize, int tagsSize, int lemmasSize) throws IllegalArgumentException {
        if (tokensSize != tagsSize || tagsSize != lemmasSize) {
            throw new IllegalArgumentException("All arrays must have the same length: sentenceSize: " + tokensSize + ", tagsSize: " + tagsSize + ", predsSize: " + lemmasSize + "!");
        }
    }

    public String toString() {
        StringBuilder lemmaString = new StringBuilder();
        for (int ci = 0; ci < this.lemmas.size(); ++ci) {
            lemmaString.append(this.tokens.get(ci)).append("\t").append(this.tags.get(ci)).append("\t").append(this.lemmas.get(ci)).append("\n");
        }
        return lemmaString.toString();
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.getTokens()), Arrays.hashCode(this.getTags()), Arrays.hashCode(this.getLemmas()));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LemmaSample) {
            LemmaSample a = (LemmaSample)obj;
            return Arrays.equals(this.getTokens(), a.getTokens()) && Arrays.equals(this.getTags(), a.getTags()) && Arrays.equals(this.getLemmas(), a.getLemmas());
        }
        return false;
    }
}

