/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.ssl;

import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;
import org.apache.nifi.security.ssl.KeyManagerListener;

public class StandardX509ExtendedKeyManager
extends X509ExtendedKeyManager
implements KeyManagerListener {
    private final AtomicReference<X509ExtendedKeyManager> keyManagerRef;

    public StandardX509ExtendedKeyManager(X509ExtendedKeyManager keyManager) {
        Objects.requireNonNull(keyManager, "Key Manager required");
        this.keyManagerRef = new AtomicReference<X509ExtendedKeyManager>(keyManager);
    }

    @Override
    public void setKeyManager(X509ExtendedKeyManager keyManager) {
        Objects.requireNonNull(keyManager, "Key Manager required");
        this.keyManagerRef.lazySet(keyManager);
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        return this.keyManagerRef.get().getClientAliases(keyType, issuers);
    }

    @Override
    public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
        return this.keyManagerRef.get().chooseClientAlias(keyType, issuers, socket);
    }

    @Override
    public String chooseEngineClientAlias(String[] keyType, Principal[] issuers, SSLEngine engine) {
        return this.keyManagerRef.get().chooseEngineClientAlias(keyType, issuers, engine);
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        return this.keyManagerRef.get().getServerAliases(keyType, issuers);
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        return this.keyManagerRef.get().chooseServerAlias(keyType, issuers, socket);
    }

    @Override
    public String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine engine) {
        return this.keyManagerRef.get().chooseEngineServerAlias(keyType, issuers, engine);
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        return this.keyManagerRef.get().getCertificateChain(alias);
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        return this.keyManagerRef.get().getPrivateKey(alias);
    }
}

