/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language.evaluation.functions;

import org.apache.nifi.attribute.expression.language.EvaluationContext;
import org.apache.nifi.attribute.expression.language.evaluation.Evaluator;
import org.apache.nifi.attribute.expression.language.evaluation.QueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.WholeNumberEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.WholeNumberQueryResult;

public class LastIndexOfEvaluator
extends WholeNumberEvaluator {
    private final Evaluator<String> subject;
    private final Evaluator<String> indexEvaluator;

    public LastIndexOfEvaluator(Evaluator<String> subject, Evaluator<String> indexEvaluator) {
        this.subject = subject;
        this.indexEvaluator = indexEvaluator;
    }

    @Override
    public QueryResult<Long> evaluate(EvaluationContext evaluationContext) {
        String subjectValue = this.subject.evaluate(evaluationContext).getValue();
        if (subjectValue == null) {
            return new WholeNumberQueryResult(-1L);
        }
        String indexEvalValue = this.indexEvaluator.evaluate(evaluationContext).getValue();
        return new WholeNumberQueryResult(Long.valueOf(subjectValue.lastIndexOf(indexEvalValue)));
    }

    @Override
    public Evaluator<?> getSubjectEvaluator() {
        return this.subject;
    }
}

