/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.util;

import org.flywaydb.core.internal.util.StringUtils;

public final class TimeSpecifierUtils {
    public static Long parseToSeconds(String value) {
        if (!StringUtils.hasText(value)) {
            throw new NumberFormatException("time specifier is empty");
        }
        char specifier = value.charAt(value.length() - 1);
        if (Character.isDigit(specifier)) {
            return Long.parseLong(value);
        }
        long number = Long.parseLong(value.substring(0, value.length() - 1));
        switch (specifier) {
            case 's': {
                return number;
            }
            case 'm': {
                return number * 60L;
            }
            case 'h': {
                return number * 60L * 60L;
            }
            case 'd': {
                return number * 60L * 60L * 24L;
            }
        }
        throw new NumberFormatException("unknown time specifier " + specifier);
    }

    public static Long tryParseToSeconds(String value) {
        try {
            return value != null ? TimeSpecifierUtils.parseToSeconds(value) : null;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

