/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.server;

import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.util.HostPort;
import org.eclipse.jetty.util.URIUtil;

public class AuthorityCustomizer
implements HttpConfiguration.Customizer {
    public Request customize(Request request, HttpFields.Mutable responseHeaders) {
        if (request.getConnectionMetaData().getHttpVersion().getVersion() < 20) {
            return request;
        }
        HttpURI httpURI = request.getHttpURI();
        if (httpURI.hasAuthority() && !httpURI.getAuthority().isEmpty()) {
            return request;
        }
        String hostPort = request.getHeaders().get(HttpHeader.HOST);
        if (hostPort == null) {
            String host = Request.getServerName((Request)request);
            int port = URIUtil.normalizePortForScheme((String)httpURI.getScheme(), (int)Request.getServerPort((Request)request));
            hostPort = new HostPort(host, port).toString();
        }
        HttpURI.Immutable newHttpURI = HttpURI.build((HttpURI)httpURI).authority(hostPort).asImmutable();
        return new Request.Wrapper(this, request, (HttpURI)newHttpURI){
            final /* synthetic */ HttpURI val$newHttpURI;
            final /* synthetic */ AuthorityCustomizer this$0;
            {
                this.val$newHttpURI = httpURI;
                this.this$0 = this$0;
                super(arg0);
            }

            public HttpURI getHttpURI() {
                return this.val$newHttpURI;
            }
        };
    }
}

