/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import jakarta.faces.FacesException;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.visit.VisitContext;
import jakarta.faces.component.visit.VisitResult;
import jakarta.faces.context.FacesContext;
import java.io.IOException;
import org.apache.myfaces.tobago.component.LabelLayout;
import org.apache.myfaces.tobago.component.SupportsLabelLayout;
import org.apache.myfaces.tobago.component.SupportsSegmentLayout;
import org.apache.myfaces.tobago.component.UIStyle;
import org.apache.myfaces.tobago.component.Visual;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.internal.component.AbstractUISegmentLayout;
import org.apache.myfaces.tobago.layout.SegmentJustify;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.css.CssItem;
import org.apache.myfaces.tobago.renderkit.css.TobagoClass;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class SegmentLayoutRenderer<T extends AbstractUISegmentLayout>
extends RendererBase<T> {
    public boolean getRendersChildren() {
        return true;
    }

    @Override
    public void encodeBeginInternal(FacesContext facesContext, T component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        Markup markup = component.getMarkup();
        SegmentJustify segmentJustify = component.getJustify();
        writer.startElement(HtmlElements.TOBAGO_SEGMENT_LAYOUT);
        writer.writeIdAttribute(component.getClientId(facesContext));
        writer.writeClassAttribute(BootstrapClass.ROW, segmentJustify != null ? BootstrapClass.segmentJustify(segmentJustify) : null, markup != null && markup.contains(Markup.SPREAD) ? TobagoClass.SPREAD : null);
    }

    @Override
    public void encodeChildrenInternal(FacesContext facesContext, T component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        BootstrapClass.Generator generator = new BootstrapClass.Generator((SupportsSegmentLayout)component);
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        component.visitTree(VisitContext.createVisitContext((FacesContext)facesContext, null, ComponentUtils.SET_SKIP_UNRENDERED), (context, target) -> {
            if (!target.getClientId(facesContext).equals(component.getClientId(facesContext)) && (target instanceof Visual && !((Visual)target).isPlain() || ComponentUtils.isStandardHtmlRendererType(target))) {
                try {
                    this.encodeChild(facesContext, writer, generator, target);
                }
                catch (IOException ioException) {
                    throw new FacesException((Throwable)ioException);
                }
                return VisitResult.REJECT;
            }
            if (target instanceof UIStyle) {
                try {
                    target.encodeAll(facesContext);
                }
                catch (IOException ioException) {
                    throw new FacesException((Throwable)ioException);
                }
                return VisitResult.REJECT;
            }
            return VisitResult.ACCEPT;
        });
    }

    private void encodeChild(FacesContext facesContext, TobagoResponseWriter writer, BootstrapClass.Generator generator, UIComponent child) throws IOException {
        if (child instanceof SupportsLabelLayout && LabelLayout.isSegment(((SupportsLabelLayout)child).getLabelLayout())) {
            SupportsLabelLayout labeledChild;
            labeledChild.setNextToRenderIsLabel((labeledChild = (SupportsLabelLayout)child).getLabelLayout() == LabelLayout.segmentLeft);
            this.encodeDiv(facesContext, writer, generator, child);
            generator.next();
            labeledChild.setNextToRenderIsLabel(labeledChild.getLabelLayout() == LabelLayout.segmentRight);
            this.encodeDiv(facesContext, writer, generator, child);
            generator.next();
            LabelLayout.removeSegment(facesContext);
        } else {
            this.encodeDiv(facesContext, writer, generator, child);
            generator.next();
        }
    }

    private void encodeDiv(FacesContext facesContext, TobagoResponseWriter writer, BootstrapClass.Generator generator, UIComponent child) throws IOException {
        writer.startElement(HtmlElements.DIV);
        writer.writeClassAttribute((CssItem)null, (CssItem[])null, (CssItem[])generator.generate(child));
        child.encodeAll(facesContext);
        writer.endElement(HtmlElements.DIV);
    }

    @Override
    public void encodeEndInternal(FacesContext facesContext, T component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.endElement(HtmlElements.TOBAGO_SEGMENT_LAYOUT);
    }
}

