/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.context;

import jakarta.faces.FacesException;
import jakarta.faces.application.FacesMessage;
import jakarta.faces.application.NavigationHandler;
import jakarta.faces.application.ViewExpiredException;
import jakarta.faces.application.ViewHandler;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.context.ExceptionHandler;
import jakarta.faces.context.ExceptionHandlerWrapper;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.AbortProcessingException;
import jakarta.faces.event.ExceptionQueuedEvent;
import jakarta.faces.event.ExceptionQueuedEventContext;
import jakarta.faces.event.PhaseId;
import jakarta.faces.event.PreRenderViewEvent;
import jakarta.faces.view.ViewDeclarationLanguage;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Iterator;
import org.apache.myfaces.tobago.util.WebXmlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TobagoExceptionHandler
extends ExceptionHandlerWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public TobagoExceptionHandler(ExceptionHandler delegate) {
        super(delegate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle() throws FacesException {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext.getPartialViewContext().isAjaxRequest()) {
            Throwable exception;
            Iterator events = this.getUnhandledExceptionQueuedEvents().iterator();
            if (events.hasNext() && !((exception = ((ExceptionQueuedEvent)events.next()).getContext().getException()) instanceof AbortProcessingException)) {
                String errorPageLocation = WebXmlUtils.getErrorPageLocation(exception);
                if (!(errorPageLocation == null || facesContext.getCurrentPhaseId() == PhaseId.RENDER_RESPONSE && facesContext.getExternalContext().isResponseCommitted())) {
                    try {
                        HttpServletRequest request = (HttpServletRequest)facesContext.getExternalContext().getRequest();
                        HttpServletResponse response = (HttpServletResponse)facesContext.getExternalContext().getResponse();
                        request.setAttribute("jakarta.servlet.error.exception", (Object)exception);
                        request.setAttribute("jakarta.servlet.error.exception_type", exception.getClass());
                        request.setAttribute("jakarta.servlet.error.message", (Object)exception.getMessage());
                        request.setAttribute("jakarta.servlet.error.request_uri", (Object)request.getRequestURI());
                        request.setAttribute("jakarta.servlet.error.status_code", (Object)500);
                        response.setStatus(500);
                        this.renderErrorPage(facesContext, errorPageLocation);
                        this.cleanupExceptionQueuedEvents();
                    }
                    catch (IOException e) {
                        throw new FacesException((Throwable)e);
                    }
                } else {
                    LOG.debug("Can't return an error page. errorPageLocation='{}'", (Object)errorPageLocation);
                }
            }
        } else {
            Iterator iterator = this.getUnhandledExceptionQueuedEvents().iterator();
            while (iterator.hasNext()) {
                ExceptionQueuedEvent event = (ExceptionQueuedEvent)iterator.next();
                ExceptionQueuedEventContext context = (ExceptionQueuedEventContext)event.getSource();
                Throwable cause = this.getWrapped().getRootCause(context.getException());
                if (cause == null) {
                    cause = context.getException();
                }
                NavigationHandler nav = facesContext.getApplication().getNavigationHandler();
                if (cause instanceof ViewExpiredException || cause != null && cause.getCause() instanceof ViewExpiredException) {
                    ViewExpiredException viewExpiredException = (ViewExpiredException)(cause instanceof ViewExpiredException ? cause : cause.getCause());
                    try {
                        facesContext.addMessage(null, new FacesMessage(FacesMessage.SEVERITY_WARN, "The view has been expired!", "Please check the given data or try to start from the beginning."));
                        nav.handleNavigation(facesContext, null, viewExpiredException.getViewId());
                        facesContext.renderResponse();
                        LOG.debug("Handling ViewExpiredException on viewId: {}", (Object)viewExpiredException.getViewId());
                        continue;
                    }
                    finally {
                        iterator.remove();
                        continue;
                    }
                }
                try {
                    FacesMessage message;
                    boolean error404;
                    boolean bl = error404 = cause instanceof FileNotFoundException || cause != null && cause.getCause() instanceof FileNotFoundException;
                    if (error404) {
                        message = new FacesMessage(FacesMessage.SEVERITY_ERROR, "The page was not found!", "The requested page was not found!");
                        facesContext.getExternalContext().setResponseStatus(404);
                        LOG.warn("Handling 404 exception.");
                    } else {
                        message = new FacesMessage(FacesMessage.SEVERITY_ERROR, "An unknown error has occurred! xxx", "An unknown error has occurred! xxx");
                        facesContext.getExternalContext().setResponseStatus(500);
                        LOG.warn("Handling 500 exception.", cause);
                    }
                    facesContext.addMessage(null, message);
                    String viewId = "/tobago/error.xhtml";
                    if (event.getContext().getPhaseId().getOrdinal() < PhaseId.RENDER_RESPONSE.getOrdinal()) {
                        nav.handleNavigation(facesContext, null, "/tobago/error.xhtml");
                        facesContext.renderResponse();
                        continue;
                    }
                    HttpServletResponse response = (HttpServletResponse)facesContext.getExternalContext().getResponse();
                    response.resetBuffer();
                    ViewHandler viewHandler = facesContext.getApplication().getViewHandler();
                    ViewDeclarationLanguage vdl = viewHandler.getViewDeclarationLanguage(facesContext, "/tobago/error.xhtml");
                    UIViewRoot viewRoot = viewHandler.createView(facesContext, "/tobago/error.xhtml");
                    vdl.buildView(facesContext, viewRoot);
                    facesContext.getApplication().publishEvent(facesContext, PreRenderViewEvent.class, (Object)viewRoot);
                    vdl.renderView(facesContext, viewRoot);
                }
                catch (Exception e) {
                    LOG.error("Exception while exception handling!", (Throwable)e);
                }
                finally {
                    facesContext.responseComplete();
                    iterator.remove();
                }
            }
        }
        super.handle();
    }

    private void renderErrorPage(FacesContext facesContext, String errorPageLocation) throws IOException {
        ViewHandler viewHandler = facesContext.getApplication().getViewHandler();
        UIViewRoot viewRoot = viewHandler.createView(facesContext, errorPageLocation);
        facesContext.setViewRoot(viewRoot);
        facesContext.getPartialViewContext().setRenderAll(true);
        ViewDeclarationLanguage viewDeclarationLanguage = viewHandler.getViewDeclarationLanguage(facesContext, errorPageLocation);
        viewDeclarationLanguage.buildView(facesContext, viewRoot);
        facesContext.getApplication().publishEvent(facesContext, PreRenderViewEvent.class, (Object)viewRoot);
        viewDeclarationLanguage.renderView(facesContext, viewRoot);
        facesContext.responseComplete();
    }

    private void cleanupExceptionQueuedEvents() {
        Iterator exceptionQueuedEvents = this.getUnhandledExceptionQueuedEvents().iterator();
        while (exceptionQueuedEvents.hasNext()) {
            exceptionQueuedEvents.next();
            exceptionQueuedEvents.remove();
        }
    }
}

