/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.behavior;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.component.StateHelper;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.exception.TobagoException;
import org.apache.myfaces.tobago.internal.behavior.AttachedListStateWrapper;
import org.apache.myfaces.tobago.internal.behavior.AttachedStateWrapper;
import org.apache.myfaces.tobago.internal.behavior.EventBehavior;

class DeltaStateHelper<A extends EventBehavior>
implements StateHelper {
    private A target;
    private Map<Serializable, Object> fullState;
    private Map<Serializable, Object> deltas;
    private boolean transientBoolean = false;

    DeltaStateHelper(A target) {
        this.target = target;
        this.fullState = new HashMap<Serializable, Object>();
        this.deltas = null;
    }

    private boolean createDeltas() {
        if (this.isInitialStateMarked()) {
            if (this.deltas == null) {
                this.deltas = new HashMap<Serializable, Object>(2);
            }
            return true;
        }
        return false;
    }

    protected boolean isInitialStateMarked() {
        return this.target.initialStateMarked();
    }

    public void add(Serializable key, Object value) {
        InternalList fullListValues;
        if (this.createDeltas()) {
            InternalDeltaListMap<Object, Boolean> deltaListMapValues = (InternalDeltaListMap<Object, Boolean>)this.deltas.get(key);
            if (deltaListMapValues == null) {
                deltaListMapValues = new InternalDeltaListMap<Object, Boolean>(3);
                this.deltas.put(key, deltaListMapValues);
            }
            deltaListMapValues.put(value, Boolean.TRUE);
        }
        if ((fullListValues = (InternalList)this.fullState.get(key)) == null) {
            fullListValues = new InternalList(3);
            this.fullState.put(key, fullListValues);
        }
        fullListValues.add(value);
    }

    public Object eval(Serializable key) {
        Object returnValue = this.fullState.get(key);
        if (returnValue != null) {
            return returnValue;
        }
        ValueExpression expression = ((EventBehavior)((Object)this.target)).getValueExpression(key.toString());
        if (expression != null) {
            return expression.getValue(FacesContext.getCurrentInstance().getELContext());
        }
        return null;
    }

    public Object eval(Serializable key, Object defaultValue) {
        Object returnValue = this.fullState.get(key);
        if (returnValue != null) {
            return returnValue;
        }
        ValueExpression expression = ((EventBehavior)((Object)this.target)).getValueExpression(key.toString());
        if (expression != null) {
            return expression.getValue(FacesContext.getCurrentInstance().getELContext());
        }
        return defaultValue;
    }

    public Object get(Serializable key) {
        return this.fullState.get(key);
    }

    public Object put(Serializable key, Object value) {
        Object returnValue = null;
        if (this.createDeltas()) {
            if (this.deltas.containsKey(key)) {
                returnValue = this.deltas.put(key, value);
                this.fullState.put(key, value);
            } else if (value == null && !this.fullState.containsKey(key)) {
                returnValue = null;
            } else {
                this.deltas.put(key, value);
                returnValue = this.fullState.put(key, value);
            }
        } else {
            returnValue = this.fullState.put(key, value);
        }
        return returnValue;
    }

    public Object put(Serializable key, String mapKey, Object value) {
        InternalMap<String, Object> mapValues;
        boolean returnSet = false;
        Object returnValue = null;
        if (this.createDeltas()) {
            mapValues = (InternalMap<String, Object>)this.deltas.get(key);
            if (mapValues == null) {
                mapValues = new InternalMap<String, Object>();
                this.deltas.put(key, mapValues);
            }
            if (mapValues.containsKey(mapKey)) {
                returnValue = mapValues.put(mapKey, value);
                returnSet = true;
            } else {
                mapValues.put(mapKey, value);
            }
        }
        if ((mapValues = (Map)this.fullState.get(key)) == null) {
            mapValues = new InternalMap();
            this.fullState.put(key, mapValues);
        }
        if (returnSet) {
            mapValues.put(mapKey, value);
        } else {
            returnValue = mapValues.put(mapKey, value);
        }
        return returnValue;
    }

    public Object remove(Serializable key) {
        Object returnValue = null;
        if (this.createDeltas()) {
            if (this.deltas.containsKey(key)) {
                returnValue = this.deltas.put(key, null);
                this.fullState.remove(key);
            } else {
                this.deltas.put(key, null);
                returnValue = this.fullState.remove(key);
            }
        } else {
            returnValue = this.fullState.remove(key);
        }
        return returnValue;
    }

    public Object remove(Serializable key, Object valueOrKey) {
        Object collectionOrMap = this.fullState.get(key);
        Object returnValue = null;
        if (collectionOrMap instanceof InternalMap) {
            if (this.createDeltas()) {
                returnValue = DeltaStateHelper.removeValueOrKeyFromMap(this.deltas, key, valueOrKey, true);
                DeltaStateHelper.removeValueOrKeyFromMap(this.fullState, key, valueOrKey, false);
            } else {
                returnValue = DeltaStateHelper.removeValueOrKeyFromMap(this.fullState, key, valueOrKey, false);
            }
        } else if (collectionOrMap instanceof InternalList) {
            if (this.createDeltas()) {
                returnValue = DeltaStateHelper.removeValueOrKeyFromCollectionDelta(this.deltas, key, valueOrKey);
                DeltaStateHelper.removeValueOrKeyFromCollection(this.fullState, key, valueOrKey);
            } else {
                returnValue = DeltaStateHelper.removeValueOrKeyFromCollection(this.fullState, key, valueOrKey);
            }
        }
        return returnValue;
    }

    private static Object removeValueOrKeyFromCollectionDelta(Map<Serializable, Object> stateMap, Serializable key, Object valueOrKey) {
        Object returnValue = null;
        Map c = (Map)stateMap.get(key);
        if (c != null) {
            if (c.containsKey(valueOrKey)) {
                returnValue = valueOrKey;
            }
            c.put(valueOrKey, Boolean.FALSE);
        }
        return returnValue;
    }

    private static Object removeValueOrKeyFromCollection(Map<Serializable, Object> stateMap, Serializable key, Object valueOrKey) {
        Object returnValue = null;
        Collection c = (Collection)stateMap.get(key);
        if (c != null) {
            if (c.remove(valueOrKey)) {
                returnValue = valueOrKey;
            }
            if (c.isEmpty()) {
                stateMap.remove(key);
            }
        }
        return returnValue;
    }

    private static Object removeValueOrKeyFromMap(Map<Serializable, Object> stateMap, Serializable key, Object valueOrKey, boolean delta) {
        if (valueOrKey == null) {
            return null;
        }
        Object returnValue = null;
        Map map = (Map)stateMap.get(key);
        if (map != null) {
            returnValue = delta ? map.put((String)valueOrKey, null) : map.remove(valueOrKey);
            if (map.isEmpty()) {
                stateMap.put(key, null);
            }
        }
        return returnValue;
    }

    public boolean isTransient() {
        return this.transientBoolean;
    }

    public Object saveState(FacesContext context) {
        Map<Serializable, Object> serializableMap;
        Map<Serializable, Object> map = serializableMap = this.isInitialStateMarked() ? this.deltas : this.fullState;
        if (serializableMap == null || serializableMap.size() == 0) {
            return null;
        }
        Object[] retArr = new Object[serializableMap.entrySet().size() * 2];
        Iterator<Map.Entry<Serializable, Object>> it = serializableMap.entrySet().iterator();
        int cnt = 0;
        while (it.hasNext()) {
            Object savedValue;
            Map.Entry<Serializable, Object> entry = it.next();
            retArr[cnt] = entry.getKey();
            Object value = entry.getValue();
            retArr[cnt + 1] = value instanceof StateHolder || value instanceof List || !(value instanceof Serializable) ? (savedValue = DeltaStateHelper.saveAttachedState(context, value)) : value;
            cnt += 2;
        }
        return retArr;
    }

    public void restoreState(FacesContext context, Object state) {
        if (state == null) {
            return;
        }
        Object[] serializedState = (Object[])state;
        if (!this.isInitialStateMarked() && !this.fullState.isEmpty()) {
            this.fullState.clear();
            if (this.deltas != null) {
                this.deltas.clear();
            }
        }
        for (int cnt = 0; cnt < serializedState.length; cnt += 2) {
            Serializable key = (Serializable)serializedState[cnt];
            Object savedValue = DeltaStateHelper.restoreAttachedState(context, serializedState[cnt + 1]);
            if (this.isInitialStateMarked()) {
                if (savedValue instanceof InternalDeltaListMap) {
                    for (Map.Entry mapEntry : ((Map)savedValue).entrySet()) {
                        boolean addOrRemove = (Boolean)mapEntry.getValue();
                        if (addOrRemove) {
                            this.add(key, mapEntry.getKey());
                            continue;
                        }
                        this.remove(key, mapEntry.getKey());
                    }
                    continue;
                }
                if (savedValue instanceof InternalMap) {
                    for (Map.Entry mapEntry : ((Map)savedValue).entrySet()) {
                        this.put(key, (String)mapEntry.getKey(), mapEntry.getValue());
                    }
                    continue;
                }
                this.put(key, savedValue);
                continue;
            }
            this.put(key, savedValue);
        }
    }

    public void setTransient(boolean transientValue) {
        this.transientBoolean = transientValue;
    }

    private static Object saveAttachedState(FacesContext context, Object attachedObject) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (attachedObject == null) {
            return null;
        }
        if (attachedObject instanceof StateHolder) {
            StateHolder holder = (StateHolder)attachedObject;
            if (holder.isTransient()) {
                return null;
            }
            return new AttachedStateWrapper(attachedObject.getClass(), holder.saveState(context));
        }
        if (attachedObject instanceof List) {
            ArrayList<Object> lst = new ArrayList<Object>(((List)attachedObject).size());
            for (Object item : (List)attachedObject) {
                if (item == null) continue;
                lst.add(DeltaStateHelper.saveAttachedState(context, item));
            }
            return new AttachedListStateWrapper(lst);
        }
        if (attachedObject instanceof Serializable) {
            return attachedObject;
        }
        return new AttachedStateWrapper(attachedObject.getClass(), null);
    }

    private static Object restoreAttachedState(FacesContext context, Object stateObj) throws IllegalStateException {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (stateObj == null) {
            return null;
        }
        if (stateObj instanceof AttachedListStateWrapper) {
            List<Object> lst = ((AttachedListStateWrapper)stateObj).getWrappedStateList();
            ArrayList<Object> restoredList = new ArrayList<Object>(lst.size());
            for (Object item : lst) {
                restoredList.add(DeltaStateHelper.restoreAttachedState(context, item));
            }
            return restoredList;
        }
        if (stateObj instanceof AttachedStateWrapper) {
            Object restoredObject;
            Class<?> clazz = ((AttachedStateWrapper)stateObj).getClazz();
            try {
                restoredObject = clazz.newInstance();
            }
            catch (InstantiationException e) {
                throw new TobagoException("Could not restore StateHolder of type " + clazz.getName() + " (missing no-args constructor?)", e);
            }
            catch (IllegalAccessException e) {
                throw new TobagoException(e);
            }
            if (restoredObject instanceof StateHolder) {
                AttachedStateWrapper wrapper = (AttachedStateWrapper)stateObj;
                Object wrappedState = wrapper.getWrappedStateObject();
                StateHolder holder = (StateHolder)restoredObject;
                holder.restoreState(context, wrappedState);
            }
            return restoredObject;
        }
        return stateObj;
    }

    static class InternalDeltaListMap<K, V>
    extends InternalMap<K, V> {
        InternalDeltaListMap() {
        }

        InternalDeltaListMap(int initialCapacity, float loadFactor) {
            super(initialCapacity, loadFactor);
        }

        InternalDeltaListMap(int initialSize) {
            super(initialSize);
        }

        InternalDeltaListMap(Map<? extends K, ? extends V> m) {
            super(m);
        }
    }

    static class InternalList<T>
    extends ArrayList<T>
    implements StateHolder {
        InternalList() {
        }

        InternalList(Collection<? extends T> c) {
            super(c);
        }

        InternalList(int initialSize) {
            super(initialSize);
        }

        public boolean isTransient() {
            return false;
        }

        public void setTransient(boolean newTransientValue) {
        }

        public void restoreState(FacesContext context, Object state) {
            Object[] listAsArr;
            for (Object elem : listAsArr = (Object[])state) {
                this.add(DeltaStateHelper.restoreAttachedState(context, elem));
            }
        }

        public Object saveState(FacesContext context) {
            Object[] values = new Object[this.size()];
            for (int i = 0; i < this.size(); ++i) {
                Object value = this.get(i);
                values[i] = value instanceof StateHolder || value instanceof List || !(value instanceof Serializable) ? DeltaStateHelper.saveAttachedState(context, value) : value;
            }
            return values;
        }
    }

    static class InternalMap<K, V>
    extends HashMap<K, V>
    implements StateHolder {
        InternalMap() {
        }

        InternalMap(int initialCapacity, float loadFactor) {
            super(initialCapacity, loadFactor);
        }

        InternalMap(Map<? extends K, ? extends V> m) {
            super(m);
        }

        InternalMap(int initialSize) {
            super(initialSize);
        }

        public boolean isTransient() {
            return false;
        }

        public void setTransient(boolean newTransientValue) {
        }

        public void restoreState(FacesContext context, Object state) {
            Object[] listAsMap = (Object[])state;
            for (int cnt = 0; cnt < listAsMap.length; cnt += 2) {
                this.put(listAsMap[cnt], UIComponentBase.restoreAttachedState((FacesContext)context, (Object)listAsMap[cnt + 1]));
            }
        }

        public Object saveState(FacesContext context) {
            int cnt = 0;
            Object[] mapArr = new Object[this.size() * 2];
            for (Map.Entry entry : this.entrySet()) {
                mapArr[cnt] = entry.getKey();
                Object value = entry.getValue();
                mapArr[cnt + 1] = value instanceof StateHolder || value instanceof List || !(value instanceof Serializable) ? DeltaStateHelper.saveAttachedState(context, value) : value;
                cnt += 2;
            }
            return mapArr;
        }
    }
}

