/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.maven.plugin.testing;

import javax.inject.Inject;

import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;

public class ProvidesInjectMojo extends AbstractMojo {

    private final MavenSession session;
    private final MavenProject project;
    private final MojoExecution mojoExecution;
    private final TestBean testBean;

    @Inject
    public ProvidesInjectMojo(
            MavenSession session, MavenProject project, MojoExecution mojoExecution, TestBean testBean) {
        this.session = session;
        this.project = project;
        this.mojoExecution = mojoExecution;
        this.testBean = testBean;
    }

    @Override
    public void execute() {}

    public MavenSession getSession() {
        return session;
    }

    public MavenSession getSessionFromBean() {
        return testBean.getSession();
    }

    public MavenProject getProject() {
        return project;
    }

    public MavenProject getProjectFromBean() {
        return testBean.getProject();
    }

    public MojoExecution getMojoExecution() {
        return mojoExecution;
    }

    public MojoExecution getMojoExecutionFromBean() {
        return testBean.getMojoExecution();
    }
}
