/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.search;

import java.io.IOException;
import java.util.concurrent.Executor;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.FilterWeight;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.Weight;

public class ScorerIndexSearcher
extends IndexSearcher {
    public ScorerIndexSearcher(IndexReader r, Executor executor) {
        super(r, executor);
    }

    public ScorerIndexSearcher(IndexReader r) {
        super(r);
    }

    protected void searchLeaf(LeafReaderContext ctx, int minDocId, int maxDocId, Weight weight, Collector collector) throws IOException {
        FilterWeight filterWeight = new FilterWeight(this, weight){

            public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
                final ScorerSupplier in = super.scorerSupplier(context);
                if (in == null) {
                    return null;
                }
                return new ScorerSupplier(this){

                    public Scorer get(long leadCost) throws IOException {
                        return in.get(leadCost);
                    }

                    public BulkScorer bulkScorer() throws IOException {
                        return super.bulkScorer();
                    }

                    public long cost() {
                        return in.cost();
                    }
                };
            }
        };
        super.searchLeaf(ctx, minDocId, maxDocId, (Weight)filterWeight, collector);
    }
}

