/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.quality.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.StoredFields;

public class DocNameExtractor {
    private final String docNameField;

    public DocNameExtractor(String docNameField) {
        this.docNameField = docNameField;
    }

    public String docName(StoredFields storedFields, int docid) throws IOException {
        final ArrayList name = new ArrayList();
        storedFields.document(docid, new StoredFieldVisitor(){

            public void stringField(FieldInfo fieldInfo, String value) {
                name.add(Objects.requireNonNull(value, "String value should not be null"));
            }

            public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) {
                if (!name.isEmpty()) {
                    return StoredFieldVisitor.Status.STOP;
                }
                if (fieldInfo.name.equals(DocNameExtractor.this.docNameField)) {
                    return StoredFieldVisitor.Status.YES;
                }
                return StoredFieldVisitor.Status.NO;
            }
        });
        if (name.size() != 0) {
            return (String)name.get(0);
        }
        return null;
    }
}

