/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.sentdetect;

import java.io.IOException;
import opennlp.tools.commons.ThreadSafe;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.sentdetect.SentenceDetector;
import opennlp.tools.sentdetect.SentenceDetectorME;
import opennlp.tools.sentdetect.SentenceModel;
import opennlp.tools.util.DownloadUtil;
import opennlp.tools.util.Span;

@ThreadSafe
public class ThreadSafeSentenceDetectorME
implements SentenceDetector,
AutoCloseable {
    private final SentenceModel model;
    private final Dictionary abbDict;
    private final ThreadLocal<SentenceDetectorME> threadLocal = new ThreadLocal();

    public ThreadSafeSentenceDetectorME(String language) throws IOException {
        this(DownloadUtil.downloadModel(language, DownloadUtil.ModelType.SENTENCE_DETECTOR, SentenceModel.class));
    }

    public ThreadSafeSentenceDetectorME(SentenceModel model) {
        this(model, model.getAbbreviations());
    }

    public ThreadSafeSentenceDetectorME(SentenceModel model, Dictionary abbDict) {
        this.model = model;
        this.abbDict = abbDict;
    }

    private SentenceDetectorME getSD() {
        SentenceDetectorME sd = this.threadLocal.get();
        if (sd == null) {
            sd = new SentenceDetectorME(this.model, this.abbDict);
            this.threadLocal.set(sd);
        }
        return sd;
    }

    public double[] getSentenceProbabilities() {
        return this.getSD().getSentenceProbabilities();
    }

    @Override
    public String[] sentDetect(CharSequence s) {
        return this.getSD().sentDetect(s);
    }

    @Override
    public Span[] sentPosDetect(CharSequence s) {
        return this.getSD().sentPosDetect(s);
    }

    @Override
    public void close() {
        this.threadLocal.remove();
    }
}

