/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.luke.models.analysis;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.luke.models.analysis.CustomAnalyzerConfig;

public interface Analysis {
    public Collection<String> getAvailableCharFilters();

    public Collection<String> getAvailableTokenizers();

    public Collection<String> getAvailableTokenFilters();

    public Analyzer createAnalyzerFromClassName(String var1);

    public Analyzer buildCustomAnalyzer(CustomAnalyzerConfig var1);

    public List<Token> analyze(String var1);

    public Analyzer currentAnalyzer();

    public void addExternalJars(List<String> var1);

    public StepByStepResult analyzeStepByStep(String var1);

    public static class StepByStepResult {
        private List<CharfilteredText> charfilteredTexts;
        private List<NamedTokens> namedTokens;

        public StepByStepResult(List<CharfilteredText> charfilteredTexts, List<NamedTokens> namedTokens) {
            this.charfilteredTexts = charfilteredTexts;
            this.namedTokens = namedTokens;
        }

        public List<CharfilteredText> getCharfilteredTexts() {
            return this.charfilteredTexts;
        }

        public List<NamedTokens> getNamedTokens() {
            return this.namedTokens;
        }
    }

    public static class CharfilteredText
    extends NamedObject {
        private final String text;

        public CharfilteredText(String name, String text) {
            super(name);
            this.text = text;
        }

        public String getText() {
            return this.text;
        }
    }

    public static class NamedTokens
    extends NamedObject {
        private final List<Token> tokens;

        NamedTokens(String name, List<Token> tokens) {
            super(name);
            this.tokens = tokens;
        }

        public List<Token> getTokens() {
            return this.tokens;
        }
    }

    public static abstract class NamedObject {
        private final String name;

        NamedObject(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    public static class TokenAttribute {
        private final String attClass;
        private final Map<String, String> attValues;

        TokenAttribute(String attClass, Map<String, String> attValues) {
            this.attClass = Objects.requireNonNull(attClass);
            this.attValues = Objects.requireNonNull(attValues);
        }

        public String getAttClass() {
            return this.attClass;
        }

        public Map<String, String> getAttValues() {
            return Map.copyOf(this.attValues);
        }
    }

    public static class Token {
        private final String term;
        private final List<TokenAttribute> attributes;

        Token(String term, List<TokenAttribute> attributes) {
            this.term = Objects.requireNonNull(term);
            this.attributes = Objects.requireNonNull(attributes);
        }

        public String getTerm() {
            return this.term;
        }

        public List<TokenAttribute> getAttributes() {
            return List.copyOf(this.attributes);
        }
    }
}

