/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.linkis.cs.persistence.persistence;

import org.apache.linkis.cs.common.entity.listener.ContextIDListenerDomain;
import org.apache.linkis.cs.common.entity.source.ContextID;
import org.apache.linkis.cs.common.exception.CSErrorException;

import java.util.List;

public interface ContextIDListenerPersistence {

  void create(ContextID contextID, ContextIDListenerDomain contextIDListenerDomain)
      throws CSErrorException;

  void remove(ContextIDListenerDomain contextIDListenerDomain) throws CSErrorException;

  void removeAll(ContextID contextID) throws CSErrorException;

  List<ContextIDListenerDomain> getAll(ContextID contextID) throws CSErrorException;

  ContextIDListenerDomain getBy(ContextIDListenerDomain contextIDListenerDomain)
      throws CSErrorException;
}
