/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.beeline.common.util;

import com.google.common.base.Splitter;
import java.util.Iterator;

public class HiveStringUtils {
    public static String removeComments(String statement) {
        if (statement == null) {
            return null;
        }
        Iterator iterator = Splitter.on((String)"\n").omitEmptyStrings().split((CharSequence)statement).iterator();
        int[] startQuote = new int[]{-1};
        StringBuilder ret = new StringBuilder(statement.length());
        while (iterator.hasNext()) {
            String lineWithComments = (String)iterator.next();
            String lineNoComments = HiveStringUtils.removeComments(lineWithComments, startQuote);
            ret.append(lineNoComments);
            if (!iterator.hasNext() || lineNoComments.isEmpty()) continue;
            ret.append("\n");
        }
        return ret.toString();
    }

    public static String removeComments(String line, int[] startQuote) {
        if (line == null || line.isEmpty()) {
            return line;
        }
        if (startQuote[0] == -1 && HiveStringUtils.isComment(line)) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        int index = 0;
        while (index < line.length()) {
            if (startQuote[0] == -1 && index < line.length() - 1 && line.charAt(index) == '-' && line.charAt(index + 1) == '-') {
                while (index < line.length() && line.charAt(index) != '\n') {
                    ++index;
                }
                continue;
            }
            char letter = line.charAt(index);
            if (startQuote[0] == letter && (index == 0 || line.charAt(index - 1) != '\\')) {
                startQuote[0] = -1;
            } else if (!(startQuote[0] != -1 || letter != '\'' && letter != '\"' || index != 0 && line.charAt(index - 1) == '\\')) {
                startQuote[0] = letter;
            }
            builder.append(letter);
            ++index;
        }
        return builder.toString().trim();
    }

    private static boolean isComment(String line) {
        String lineTrimmed = line.trim();
        return lineTrimmed.startsWith("#") || lineTrimmed.startsWith("--");
    }
}

