/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.yarn.client.RMHAServiceTarget;
import org.apache.hadoop.yarn.conf.HAUtil;
import org.apache.hadoop.yarn.conf.YarnConfiguration;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class RMHAUtils {
    public static String findActiveRMHAId(Configuration conf) {
        YarnConfiguration yarnConf = new YarnConfiguration(conf);
        Collection<String> rmIds = yarnConf.getStringCollection("yarn.resourcemanager.ha.rm-ids");
        for (String currentId : rmIds) {
            yarnConf.set("yarn.resourcemanager.ha.id", currentId);
            try {
                HAServiceProtocol.HAServiceState haState = RMHAUtils.getHAState(yarnConf);
                if (!haState.equals((Object)HAServiceProtocol.HAServiceState.ACTIVE)) continue;
                return currentId;
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    private static HAServiceProtocol.HAServiceState getHAState(YarnConfiguration yarnConf) throws Exception {
        int rpcTimeoutForChecks = yarnConf.getInt("ha.failover-controller.cli-check.rpc-timeout.ms", 20000);
        yarnConf.set("hadoop.security.service.user.name.key", yarnConf.get("yarn.resourcemanager.principal", ""));
        RMHAServiceTarget haServiceTarget = new RMHAServiceTarget(yarnConf);
        HAServiceProtocol proto = haServiceTarget.getProxy(yarnConf, rpcTimeoutForChecks);
        HAServiceProtocol.HAServiceState haState = proto.getServiceStatus().getState();
        return haState;
    }

    public static List<String> getRMHAWebappAddresses(YarnConfiguration conf) {
        String defaultPort;
        String prefix;
        if (YarnConfiguration.useHttps(conf)) {
            prefix = "yarn.resourcemanager.webapp.https.address";
            defaultPort = ":8090";
        } else {
            prefix = "yarn.resourcemanager.webapp.address";
            defaultPort = ":8088";
        }
        Collection<String> rmIds = conf.getStringCollection("yarn.resourcemanager.ha.rm-ids");
        ArrayList<String> addrs = new ArrayList<String>();
        for (String id : rmIds) {
            String hostname;
            String addr = conf.get(HAUtil.addSuffix(prefix, id));
            if (addr == null && (hostname = conf.get(HAUtil.addSuffix("yarn.resourcemanager.hostname", id))) != null) {
                addr = hostname + defaultPort;
            }
            if (addr == null) continue;
            addrs.add(addr);
        }
        return addrs;
    }
}

