/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.Consumer;
import org.apache.camel.spi.ScheduledPollConsumerScheduler;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultScheduledPollConsumerScheduler
extends ServiceSupport
implements ScheduledPollConsumerScheduler {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultScheduledPollConsumerScheduler.class);
    private static final int DEFAULT_INITIAL_DELAY = 1000;
    private static final int DEFAULT_DELAY = 500;
    private CamelContext camelContext;
    private Consumer consumer;
    private ScheduledExecutorService scheduledExecutorService;
    private boolean shutdownExecutor;
    private volatile List<ScheduledFuture<?>> futures = new ArrayList();
    private Runnable task;
    private int concurrentTasks = 1;
    private long initialDelay = -1L;
    private long delay = -1L;
    private TimeUnit timeUnit = TimeUnit.MILLISECONDS;
    private boolean useFixedDelay = true;

    public DefaultScheduledPollConsumerScheduler() {
    }

    public DefaultScheduledPollConsumerScheduler(ScheduledExecutorService scheduledExecutorService) {
        this.scheduledExecutorService = scheduledExecutorService;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public long getInitialDelay() {
        return this.initialDelay;
    }

    public void setInitialDelay(long initialDelay) {
        this.initialDelay = initialDelay;
    }

    public long getDelay() {
        return this.delay;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    public boolean isUseFixedDelay() {
        return this.useFixedDelay;
    }

    public void setUseFixedDelay(boolean useFixedDelay) {
        this.useFixedDelay = useFixedDelay;
    }

    public ScheduledExecutorService getScheduledExecutorService() {
        return this.scheduledExecutorService;
    }

    public void setScheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
        this.scheduledExecutorService = scheduledExecutorService;
    }

    public int getConcurrentTasks() {
        return this.concurrentTasks;
    }

    public void setConcurrentTasks(int concurrentTasks) {
        this.concurrentTasks = concurrentTasks;
    }

    public void onInit(Consumer consumer) {
        this.consumer = consumer;
    }

    public void scheduleTask(Runnable task) {
        this.task = task;
    }

    public void unscheduleTask() {
        if (this.isSchedulerStarted()) {
            for (ScheduledFuture<?> future : this.futures) {
                future.cancel(true);
            }
            this.futures.clear();
        }
    }

    public void startScheduler() {
        block9: {
            long currentDelay;
            long currentInitialDelay = this.initialDelay < 0L ? this.timeUnit.convert(1000L, TimeUnit.MILLISECONDS) : this.initialDelay;
            if (this.delay <= 0L) {
                currentDelay = this.timeUnit.convert(500L, TimeUnit.MILLISECONDS);
                if (currentDelay <= 0L) {
                    currentDelay = 1L;
                }
            } else {
                currentDelay = this.delay;
            }
            if (this.futures.size() != 0) break block9;
            if (this.isUseFixedDelay()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Scheduling poll (fixed delay) with initialDelay: {}, delay: {} ({}) for: {}", new Object[]{currentInitialDelay, currentDelay, this.getTimeUnit().name().toLowerCase(Locale.ENGLISH), this.consumer.getEndpoint()});
                }
                for (int i = 0; i < this.concurrentTasks; ++i) {
                    this.futures.add(this.scheduledExecutorService.scheduleWithFixedDelay(this.task, currentInitialDelay, currentDelay, this.getTimeUnit()));
                }
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Scheduling poll (fixed rate) with initialDelay: {}, delay: {} ({}) for: {}", new Object[]{currentInitialDelay, currentDelay, this.getTimeUnit().name().toLowerCase(Locale.ENGLISH), this.consumer.getEndpoint()});
                }
                for (int i = 0; i < this.concurrentTasks; ++i) {
                    this.futures.add(this.scheduledExecutorService.scheduleAtFixedRate(this.task, currentInitialDelay, currentDelay, this.getTimeUnit()));
                }
            }
        }
    }

    public boolean isSchedulerStarted() {
        return this.futures != null && this.futures.size() > 0;
    }

    protected void doStart() throws Exception {
        ObjectHelper.notNull((Object)this.consumer, (String)"Consumer", (Object)((Object)this));
        ObjectHelper.notNull((Object)this.camelContext, (String)"CamelContext", (Object)((Object)this));
        ObjectHelper.notNull((Object)this.task, (String)"Task", (Object)((Object)this));
        if (this.scheduledExecutorService == null) {
            this.scheduledExecutorService = this.getCamelContext().getExecutorServiceManager().newScheduledThreadPool((Object)this.consumer, this.consumer.getEndpoint().getEndpointUri(), this.concurrentTasks);
            this.shutdownExecutor = true;
        }
    }

    protected void doStop() throws Exception {
        if (this.isSchedulerStarted()) {
            LOG.debug("This consumer is stopping, so cancelling scheduled task: {}", this.futures);
            for (ScheduledFuture<?> future : this.futures) {
                future.cancel(true);
            }
            this.futures.clear();
        }
        if (this.shutdownExecutor && this.scheduledExecutorService != null) {
            this.getCamelContext().getExecutorServiceManager().shutdownNow((ExecutorService)this.scheduledExecutorService);
            this.scheduledExecutorService = null;
            this.futures.clear();
        }
    }
}

