/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.net.SocketTimeoutException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import kafka.controller.QueueItem;
import kafka.controller.StateChangeLogger;
import kafka.server.KafkaConfig;
import kafka.utils.Logging;
import org.apache.kafka.clients.ClientRequest;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.clients.NetworkClientUtils;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.AbstractControlRequest;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.util.ShutdownableThread;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005mc\u0001B\r\u001b\u0001}A\u0001b\r\u0001\u0003\u0006\u0004%\t\u0001\u000e\u0005\tw\u0001\u0011\t\u0011)A\u0005k!AA\b\u0001B\u0001B\u0003%Q\b\u0003\u0005A\u0001\t\u0015\r\u0011\"\u0001B\u0011!y\u0005A!A!\u0002\u0013\u0011\u0005\u0002\u0003)\u0001\u0005\u000b\u0007I\u0011A)\t\u0011a\u0003!\u0011!Q\u0001\nIC\u0001\"\u0017\u0001\u0003\u0006\u0004%\tA\u0017\u0005\tC\u0002\u0011\t\u0011)A\u00057\"A!\r\u0001BC\u0002\u0013\u00051\r\u0003\u0005j\u0001\t\u0005\t\u0015!\u0003e\u0011!Q\u0007A!b\u0001\n\u0003Y\u0007\u0002C9\u0001\u0005\u0003\u0005\u000b\u0011\u00027\t\u0011I\u0004!Q1A\u0005\u0002MD\u0011\"!\u0001\u0001\u0005\u0003\u0005\u000b\u0011\u0002;\t\u0015\u0005\r\u0001A!b\u0001\n\u0003\t)\u0001\u0003\u0006\u0002\u000e\u0001\u0011\t\u0011)A\u0005\u0003\u000fA!\"a\u0004\u0001\u0005\u0003\u0005\u000b\u0011BA\t\u0011\u001d\t9\u0003\u0001C\u0001\u0003SA\u0001\"!\u0011\u0001\u0005\u0004%I\u0001\u000e\u0005\b\u0003\u0007\u0002\u0001\u0015!\u00036\u0011\u001d\t)\u0005\u0001C!\u0003\u000fBq!a\u0014\u0001\t\u0013\t\t\u0006C\u0004\u0002Z\u0001!\t%!\u0015\u0003#I+\u0017/^3tiN+g\u000e\u001a+ie\u0016\fGM\u0003\u0002\u001c9\u0005Q1m\u001c8ue>dG.\u001a:\u000b\u0003u\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001A5\u0002\"!I\u0016\u000e\u0003\tR!a\t\u0013\u0002\tU$\u0018\u000e\u001c\u0006\u0003K\u0019\naa]3sm\u0016\u0014(BA\u000f(\u0015\tA\u0013&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002U\u0005\u0019qN]4\n\u00051\u0012#AE*ikR$wn\u001e8bE2,G\u000b\u001b:fC\u0012\u0004\"AL\u0019\u000e\u0003=R!\u0001\r\u000f\u0002\u000bU$\u0018\u000e\\:\n\u0005Iz#a\u0002'pO\u001eLgnZ\u0001\rG>tGO]8mY\u0016\u0014\u0018\nZ\u000b\u0002kA\u0011a'O\u0007\u0002o)\t\u0001(A\u0003tG\u0006d\u0017-\u0003\u0002;o\t\u0019\u0011J\u001c;\u0002\u001b\r|g\u000e\u001e:pY2,'/\u00133!\u0003=\u0019wN\u001c;s_2dWM]#q_\u000eD\u0007c\u0001\u001c?k%\u0011qh\u000e\u0002\n\rVt7\r^5p]B\nQ!];fk\u0016,\u0012A\u0011\t\u0004\u0007&[U\"\u0001#\u000b\u0005\u00153\u0015AC2p]\u000e,(O]3oi*\u00111e\u0012\u0006\u0002\u0011\u0006!!.\u0019<b\u0013\tQEIA\u0007CY>\u001c7.\u001b8h#V,W/\u001a\t\u0003\u00196k\u0011AG\u0005\u0003\u001dj\u0011\u0011\"U;fk\u0016LE/Z7\u0002\rE,X-^3!\u00035qW\r^<pe.\u001cE.[3oiV\t!\u000b\u0005\u0002T-6\tAK\u0003\u0002VM\u000591\r\\5f]R\u001c\u0018BA,U\u00055qU\r^<pe.\u001cE.[3oi\u0006qa.\u001a;x_J\\7\t\\5f]R\u0004\u0013A\u00032s_.,'OT8eKV\t1\f\u0005\u0002]?6\tQL\u0003\u0002_M\u000511m\\7n_:L!\u0001Y/\u0003\t9{G-Z\u0001\fEJ|7.\u001a:O_\u0012,\u0007%\u0001\u0004d_:4\u0017nZ\u000b\u0002IB\u0011QmZ\u0007\u0002M*\u0011Q\u0005H\u0005\u0003Q\u001a\u00141bS1gW\u0006\u001cuN\u001c4jO\u000691m\u001c8gS\u001e\u0004\u0013\u0001\u0002;j[\u0016,\u0012\u0001\u001c\t\u0003[>l\u0011A\u001c\u0006\u0003auK!\u0001\u001d8\u0003\tQKW.Z\u0001\u0006i&lW\rI\u0001\u001fe\u0016\fX/Z:u%\u0006$X-\u00118e#V,W/\u001a+j[\u0016lU\r\u001e:jGN,\u0012\u0001\u001e\t\u0003kzl\u0011A\u001e\u0006\u0003ob\fAaY8sK*\u0011\u0011P_\u0001\b[\u0016$(/[2t\u0015\tYH0\u0001\u0004zC6lWM\u001d\u0006\u0002{\u0006\u00191m\\7\n\u0005}4(!\u0002+j[\u0016\u0014\u0018a\b:fcV,7\u000f\u001e*bi\u0016\fe\u000eZ)vKV,G+[7f\u001b\u0016$(/[2tA\u0005\t2\u000f^1uK\u000eC\u0017M\\4f\u0019><w-\u001a:\u0016\u0005\u0005\u001d\u0001c\u0001'\u0002\n%\u0019\u00111\u0002\u000e\u0003#M#\u0018\r^3DQ\u0006tw-\u001a'pO\u001e,'/\u0001\nti\u0006$Xm\u00115b]\u001e,Gj\\4hKJ\u0004\u0013\u0001\u00028b[\u0016\u0004B!a\u0005\u0002\"9!\u0011QCA\u000f!\r\t9bN\u0007\u0003\u00033Q1!a\u0007\u001f\u0003\u0019a$o\\8u}%\u0019\u0011qD\u001c\u0002\rA\u0013X\rZ3g\u0013\u0011\t\u0019#!\n\u0003\rM#(/\u001b8h\u0015\r\tybN\u0001\u0007y%t\u0017\u000e\u001e \u0015-\u0005-\u0012QFA\u0018\u0003c\t\u0019$!\u000e\u00028\u0005e\u00121HA\u001f\u0003\u007f\u0001\"\u0001\u0014\u0001\t\u000bM\u001a\u0002\u0019A\u001b\t\u000bq\u001a\u0002\u0019A\u001f\t\u000b\u0001\u001b\u0002\u0019\u0001\"\t\u000bA\u001b\u0002\u0019\u0001*\t\u000be\u001b\u0002\u0019A.\t\u000b\t\u001c\u0002\u0019\u00013\t\u000b)\u001c\u0002\u0019\u00017\t\u000bI\u001c\u0002\u0019\u0001;\t\u000f\u0005\r1\u00031\u0001\u0002\b!9\u0011qB\nA\u0002\u0005E\u0011aD:pG.,G\u000fV5nK>,H/T:\u0002!M|7m[3u)&lWm\\;u\u001bN\u0004\u0013A\u00023p/>\u00148\u000e\u0006\u0002\u0002JA\u0019a'a\u0013\n\u0007\u00055sG\u0001\u0003V]&$\u0018a\u00032s_.,'OU3bIf$\"!a\u0015\u0011\u0007Y\n)&C\u0002\u0002X]\u0012qAQ8pY\u0016\fg.\u0001\tj]&$\u0018.\u0019;f'\",H\u000fZ8x]\u0002")
public class RequestSendThread
extends ShutdownableThread
implements Logging {
    private final int controllerId;
    private final Function0<Object> controllerEpoch;
    private final BlockingQueue<QueueItem> queue;
    private final NetworkClient networkClient;
    private final Node brokerNode;
    private final KafkaConfig config;
    private final Time time;
    private final Timer requestRateAndQueueTimeMetrics;
    private final StateChangeLogger stateChangeLogger;
    private final int socketTimeoutMs;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int controllerId() {
        return this.controllerId;
    }

    public BlockingQueue<QueueItem> queue() {
        return this.queue;
    }

    public NetworkClient networkClient() {
        return this.networkClient;
    }

    public Node brokerNode() {
        return this.brokerNode;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public Time time() {
        return this.time;
    }

    public Timer requestRateAndQueueTimeMetrics() {
        return this.requestRateAndQueueTimeMetrics;
    }

    public StateChangeLogger stateChangeLogger() {
        return this.stateChangeLogger;
    }

    private int socketTimeoutMs() {
        return this.socketTimeoutMs;
    }

    /*
     * WARNING - void declaration
     */
    public void doWork() {
        QueueItem queueItem = this.queue().take();
        if (queueItem == null) {
            throw new MatchError(null);
        }
        ApiKeys apiKey = queueItem.apiKey();
        AbstractControlRequest.Builder<? extends AbstractControlRequest> requestBuilder = queueItem.request();
        Function1<AbstractResponse, BoxedUnit> callback = queueItem.callback();
        long l = queueItem.enqueueTimeMs();
        this.requestRateAndQueueTimeMetrics().update(this.time().milliseconds() - l, TimeUnit.MILLISECONDS);
        ClientResponse clientResponse = null;
        try {
            boolean isSendSuccessful = false;
            while (this.isRunning() && !isSendSuccessful) {
                void var3_3;
                try {
                    if (!this.brokerReady()) {
                        isSendSuccessful = false;
                        this.backoff$1();
                        continue;
                    }
                    ClientRequest clientRequest = this.networkClient().newClientRequest(this.brokerNode().idString(), (AbstractRequest.Builder)var3_3, this.time().milliseconds(), true);
                    clientResponse = NetworkClientUtils.sendAndReceive((KafkaClient)this.networkClient(), (ClientRequest)clientRequest, (Time)this.time());
                    isSendSuccessful = true;
                }
                catch (Throwable e) {
                    this.warn((Function0<String>)((Function0 & Serializable & scala.Serializable)() -> RequestSendThread.$anonfun$doWork$1(this, (AbstractControlRequest.Builder)var3_3)), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                    this.networkClient().close(this.brokerNode().idString());
                    isSendSuccessful = false;
                    this.backoff$1();
                }
            }
            if (clientResponse != null) {
                void var4_4;
                ApiKeys api;
                RequestHeader requestHeader = clientResponse.requestHeader();
                ApiKeys apiKeys = api = requestHeader.apiKey();
                ApiKeys apiKeys2 = ApiKeys.LEADER_AND_ISR;
                if (apiKeys == null ? apiKeys2 != null : !apiKeys.equals(apiKeys2)) {
                    ApiKeys apiKeys3 = api;
                    ApiKeys apiKeys4 = ApiKeys.STOP_REPLICA;
                    if (apiKeys3 == null ? apiKeys4 != null : !apiKeys3.equals(apiKeys4)) {
                        ApiKeys apiKeys5 = api;
                        ApiKeys apiKeys6 = ApiKeys.UPDATE_METADATA;
                        if (apiKeys5 == null ? apiKeys6 != null : !apiKeys5.equals(apiKeys6)) {
                            void var2_2;
                            throw new KafkaException(new StringBuilder(28).append("Unexpected apiKey received: ").append(var2_2).toString());
                        }
                    }
                }
                AbstractResponse response = clientResponse.responseBody();
                this.stateChangeLogger().withControllerEpoch(this.controllerEpoch.apply$mcI$sp()).trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(68).append("Received response ").append(response).append(" for request ").append(api).append(" with correlation id ").append(requestHeader.correlationId()).append(" sent to broker ").append(this.brokerNode()).toString());
                if (var4_4 != null) {
                    var4_4.apply((Object)response);
                }
            }
        }
        catch (Throwable e) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Controller ").append(this.controllerId()).append(" fails to send a request to broker ").append(this.brokerNode()).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            this.networkClient().close(this.brokerNode().idString());
        }
    }

    private boolean brokerReady() {
        try {
            if (!NetworkClientUtils.isReady((KafkaClient)this.networkClient(), (Node)this.brokerNode(), (long)this.time().milliseconds())) {
                if (!NetworkClientUtils.awaitReady((KafkaClient)this.networkClient(), (Node)this.brokerNode(), (Time)this.time(), (long)this.socketTimeoutMs())) {
                    throw new SocketTimeoutException(new StringBuilder(28).append("Failed to connect within ").append(this.socketTimeoutMs()).append(" ms").toString());
                }
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(59).append("Controller ").append(this.controllerId()).append(" connected to ").append(this.brokerNode()).append(" for sending state change requests").toString());
            }
            return true;
        }
        catch (Throwable e) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Controller ").append(this.controllerId()).append("'s connection to broker ").append(this.brokerNode()).append(" was unsuccessful").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            this.networkClient().close(this.brokerNode().idString());
            return false;
        }
    }

    public boolean initiateShutdown() {
        if (super.initiateShutdown()) {
            this.networkClient().initiateClose();
            return true;
        }
        return false;
    }

    private final void backoff$1() {
        this.pause(100L, TimeUnit.MILLISECONDS);
    }

    public static final /* synthetic */ String $anonfun$doWork$1(RequestSendThread $this, AbstractControlRequest.Builder requestBuilder$1) {
        return new StringBuilder(77).append("Controller ").append($this.controllerId()).append(" epoch ").append($this.controllerEpoch.apply$mcI$sp()).append(" fails to send request ").append(requestBuilder$1).append(" ").append("to broker ").append($this.brokerNode()).append(". Reconnecting to broker.").toString();
    }

    public RequestSendThread(int controllerId, Function0<Object> controllerEpoch, BlockingQueue<QueueItem> queue, NetworkClient networkClient, Node brokerNode, KafkaConfig config, Time time, Timer requestRateAndQueueTimeMetrics, StateChangeLogger stateChangeLogger, String name) {
        this.controllerId = controllerId;
        this.controllerEpoch = controllerEpoch;
        this.queue = queue;
        this.networkClient = networkClient;
        this.brokerNode = brokerNode;
        this.config = config;
        this.time = time;
        this.requestRateAndQueueTimeMetrics = requestRateAndQueueTimeMetrics;
        this.stateChangeLogger = stateChangeLogger;
        super(name, true, new StringBuilder(34).append("[RequestSendThread controllerId=").append(controllerId).append("] ").toString());
        Logging.$init$(this);
        this.logIdent_$eq(this.logPrefix);
        this.socketTimeoutMs = config.controllerSocketTimeoutMs();
    }
}

