/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.swaps;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.commons.utils.IoUtils;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.swap.StringSwap;

public abstract class InputStreamSwap
extends StringSwap<InputStream> {
    protected byte[] toBytes(InputStream is) throws IOException {
        return IoUtils.readBytes((InputStream)is);
    }

    protected InputStream toStream(byte[] b, ClassMeta<?> hint) {
        Class c;
        Class clazz = c = hint == null ? InputStream.class : hint.inner();
        if (c == InputStream.class || c == ByteArrayInputStream.class) {
            return new ByteArrayInputStream(b);
        }
        return null;
    }

    public static class SpacedHex
    extends InputStreamSwap {
        @Override
        public String swap(BeanSession session, InputStream is) throws Exception {
            return StringUtils.toSpacedHex((byte[])this.toBytes(is));
        }

        @Override
        public InputStream unswap(BeanSession session, String s, ClassMeta<?> hint) throws Exception {
            return this.toStream(StringUtils.fromSpacedHex((String)s), hint);
        }
    }

    public static class Hex
    extends InputStreamSwap {
        @Override
        public String swap(BeanSession session, InputStream is) throws Exception {
            return StringUtils.toHex((byte[])this.toBytes(is));
        }

        @Override
        public InputStream unswap(BeanSession session, String s, ClassMeta<?> hint) throws Exception {
            return this.toStream(StringUtils.fromHex((String)s), hint);
        }
    }

    public static class Base64
    extends InputStreamSwap {
        @Override
        public String swap(BeanSession session, InputStream is) throws Exception {
            return StringUtils.base64Encode((byte[])this.toBytes(is));
        }

        @Override
        public InputStream unswap(BeanSession session, String s, ClassMeta<?> hint) throws Exception {
            return this.toStream(StringUtils.base64Decode((String)s), hint);
        }
    }
}

