/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.msgpack;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.BeanPropertyValue;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.MediaType;
import org.apache.juneau.UriContext;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.IoUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.msgpack.MsgPackOutputStream;
import org.apache.juneau.msgpack.MsgPackSerializer;
import org.apache.juneau.serializer.OutputStreamSerializer;
import org.apache.juneau.serializer.OutputStreamSerializerSession;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.serializer.SerializerPipe;
import org.apache.juneau.serializer.SerializerSession;
import org.apache.juneau.svl.VarResolverSession;
import org.apache.juneau.swap.ObjectSwap;

public class MsgPackSerializerSession
extends OutputStreamSerializerSession {
    private final MsgPackSerializer ctx;

    public static Builder create(MsgPackSerializer ctx) {
        return new Builder((MsgPackSerializer)AssertionUtils.assertArgNotNull((String)"ctx", (Object)ctx));
    }

    private static MsgPackOutputStream getMsgPackOutputStream(SerializerPipe out) throws IOException {
        Object output = out.getRawOutput();
        if (output instanceof MsgPackOutputStream) {
            MsgPackOutputStream output2 = (MsgPackOutputStream)output;
            return output2;
        }
        MsgPackOutputStream os = new MsgPackOutputStream(out.getOutputStream());
        out.setOutputStream(os);
        return os;
    }

    protected MsgPackSerializerSession(Builder builder) {
        super(builder);
        this.ctx = builder.ctx;
    }

    private MsgPackOutputStream serializeAnything(MsgPackOutputStream out, Object o, ClassMeta<?> eType, String attrName, BeanPropertyMeta pMeta) throws SerializeException {
        boolean isRecursion;
        if (o == null) {
            return out.appendNull();
        }
        if (eType == null) {
            eType = this.object();
        }
        ClassMeta<?> aType = null;
        ClassMeta<Object> sType = null;
        aType = this.push2(attrName, o, eType);
        boolean bl = isRecursion = aType == null;
        if (aType == null) {
            return out.appendNull();
        }
        if (MsgPackSerializerSession.isOptional(aType)) {
            o = this.getOptionalValue(o);
            eType = this.getOptionalType(eType);
            aType = this.getClassMetaForObject(o, this.object());
        }
        sType = aType;
        String typeName = this.getBeanTypeName(this, eType, aType, pMeta);
        ObjectSwap<?, ?> swap = aType.getSwap(this);
        if (Utils.nn(swap)) {
            o = this.swap(swap, o);
            sType = swap.getSwapClassMeta(this);
            if (sType.isObject()) {
                sType = this.getClassMetaForObject(o);
            }
        }
        if (o == null || sType.isChar() && ((Character)o).charValue() == '\u0000') {
            out.appendNull();
        } else if (sType.isBoolean()) {
            out.appendBoolean((Boolean)o);
        } else if (sType.isNumber()) {
            out.appendNumber((Number)o);
        } else if (sType.isBean()) {
            this.serializeBeanMap(out, this.toBeanMap(o), typeName);
        } else if (sType.isUri() || Utils.nn((Object)pMeta) && pMeta.isUri()) {
            out.appendString(this.resolveUri(o.toString()));
        } else if (sType.isMap()) {
            if (o instanceof BeanMap) {
                this.serializeBeanMap(out, (BeanMap)o, typeName);
            } else {
                this.serializeMap(out, (Map)o, eType);
            }
        } else if (sType.isCollection()) {
            this.serializeCollection(out, (Collection)o, eType);
        } else if (sType.isByteArray()) {
            out.appendBinary((byte[])o);
        } else if (sType.isArray()) {
            this.serializeCollection(out, MsgPackSerializerSession.toList(sType.inner(), o), eType);
        } else if (sType.isReader()) {
            IoUtils.pipe((Reader)((Reader)o), (OutputStream)out, x$0 -> SerializerSession.handleThrown(x$0));
        } else if (sType.isInputStream()) {
            IoUtils.pipe((InputStream)((InputStream)o), (OutputStream)out, x$0 -> SerializerSession.handleThrown(x$0));
        } else {
            out.appendString(this.toString(o));
        }
        if (!isRecursion) {
            this.pop();
        }
        return out;
    }

    private void serializeBeanMap(MsgPackOutputStream out, BeanMap<?> m, String typeName) throws SerializeException {
        Predicate<Object> checkNull = x -> this.isKeepNullProperties() || Utils.nn((Object)x);
        ArrayList<BeanPropertyValue> values = new ArrayList<BeanPropertyValue>();
        if (Utils.nn((Object)typeName)) {
            BeanPropertyMeta pm = m.getMeta().getTypeProperty();
            values.add(new BeanPropertyValue(pm, pm.getName(), typeName, null));
        }
        m.forEachValue(checkNull, (pMeta, key, value, thrown) -> {
            if (Utils.nn((Object)thrown)) {
                this.onBeanGetterException((BeanPropertyMeta)pMeta, (Throwable)thrown);
                return;
            }
            BeanPropertyValue p = new BeanPropertyValue((BeanPropertyMeta)pMeta, (String)key, value, null);
            if (!this.isKeepNullProperties() && this.willRecurse(p)) {
                return;
            }
            values.add(p);
        });
        out.startMap(values.size());
        values.forEach(x -> {
            BeanPropertyMeta pMeta = x.getMeta();
            if (pMeta.canRead()) {
                ClassMeta<?> cMeta = x.getClassMeta();
                String key = x.getName();
                Object value = x.getValue();
                this.serializeAnything(out, key, null, null, null);
                this.serializeAnything(out, value, cMeta, key, pMeta);
            }
        });
    }

    private void serializeCollection(MsgPackOutputStream out, Collection c, ClassMeta<?> type) throws SerializeException {
        ClassMeta<?> elementType = type.getElementType();
        ArrayList l = CollectionUtils.listOfSize((int)c.size());
        c = this.sort(c);
        l.addAll(c);
        out.startArray(l.size());
        l.forEach(x -> this.serializeAnything(out, x, elementType, "<iterator>", null));
    }

    private void serializeMap(MsgPackOutputStream out, Map m, ClassMeta<?> type) throws SerializeException {
        ClassMeta<?> keyType = type.getKeyType();
        ClassMeta<?> valueType = type.getValueType();
        m = this.sort(m);
        ArrayList entries = CollectionUtils.listOfSize((int)m.size());
        m.forEach((k, v) -> entries.add(new SimpleMapEntry(k, v)));
        out.startMap(entries.size());
        entries.forEach(x -> {
            Object value = x.value;
            Object key = this.generalize(x.key, keyType);
            this.serializeAnything(out, key, keyType, null, null);
            this.serializeAnything(out, value, valueType, null, null);
        });
    }

    private boolean willRecurse(BeanPropertyValue v) throws SerializeException {
        ClassMeta<?> aType = this.push2(v.getName(), v.getValue(), v.getClassMeta());
        if (Utils.nn(aType)) {
            this.pop();
        }
        return aType == null;
    }

    @Override
    protected void doSerialize(SerializerPipe out, Object o) throws IOException, SerializeException {
        this.serializeAnything(MsgPackSerializerSession.getMsgPackOutputStream(out), o, this.getExpectedRootType(o), "root", null);
    }

    @Override
    protected boolean isAddBeanTypes() {
        return this.ctx.isAddBeanTypes();
    }

    public static class Builder
    extends OutputStreamSerializerSession.Builder {
        private MsgPackSerializer ctx;

        protected Builder(MsgPackSerializer ctx) {
            super((OutputStreamSerializer)AssertionUtils.assertArgNotNull((String)"ctx", (Object)ctx));
            this.ctx = ctx;
        }

        @Override
        public <T> Builder apply(Class<T> type, Consumer<T> apply) {
            super.apply((Class)type, (Consumer)apply);
            return this;
        }

        @Override
        public MsgPackSerializerSession build() {
            return new MsgPackSerializerSession(this);
        }

        @Override
        public Builder debug(Boolean value) {
            super.debug(value);
            return this;
        }

        @Override
        public Builder javaMethod(Method value) {
            super.javaMethod(value);
            return this;
        }

        @Override
        public Builder locale(Locale value) {
            super.locale(value);
            return this;
        }

        @Override
        public Builder mediaType(MediaType value) {
            super.mediaType(value);
            return this;
        }

        @Override
        public Builder mediaTypeDefault(MediaType value) {
            super.mediaTypeDefault(value);
            return this;
        }

        @Override
        public Builder properties(Map<String, Object> value) {
            super.properties((Map)value);
            return this;
        }

        @Override
        public Builder property(String key, Object value) {
            super.property(key, value);
            return this;
        }

        @Override
        public Builder resolver(VarResolverSession value) {
            super.resolver(value);
            return this;
        }

        @Override
        public Builder schema(HttpPartSchema value) {
            super.schema(value);
            return this;
        }

        @Override
        public Builder schemaDefault(HttpPartSchema value) {
            super.schemaDefault(value);
            return this;
        }

        @Override
        public Builder timeZone(TimeZone value) {
            super.timeZone(value);
            return this;
        }

        @Override
        public Builder timeZoneDefault(TimeZone value) {
            super.timeZoneDefault(value);
            return this;
        }

        @Override
        public Builder unmodifiable() {
            super.unmodifiable();
            return this;
        }

        @Override
        public Builder uriContext(UriContext value) {
            super.uriContext(value);
            return this;
        }
    }

    private static class SimpleMapEntry {
        final Object key;
        final Object value;

        SimpleMapEntry(Object key, Object value) {
            this.key = key;
            this.value = value;
        }
    }
}

