/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.annotation;

import org.apache.juneau.annotation.ExternalDocs;
import org.apache.juneau.annotation.ExternalDocsAnnotation;
import org.apache.juneau.commons.annotation.AnnotationObject;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.http.annotation.Tag;

public class TagAnnotation {
    public static final Tag DEFAULT = TagAnnotation.create().build();

    public static Builder create() {
        return new Builder();
    }

    public static class Builder
    extends AnnotationObject.Builder {
        private String[] description = new String[0];
        private ExternalDocs externalDocs = ExternalDocsAnnotation.DEFAULT;
        private String name = "";

        protected Builder() {
            super(Tag.class);
        }

        public Tag build() {
            return new Object(this);
        }

        public Builder description(String ... value) {
            this.description = value;
            return this;
        }

        public Builder externalDocs(ExternalDocs value) {
            this.externalDocs = value;
            return this;
        }

        public Builder name(String value) {
            this.name = value;
            return this;
        }
    }

    private static class Object
    extends AnnotationObject
    implements Tag {
        private final String[] description;
        private final ExternalDocs externalDocs;
        private final String name;

        Object(Builder b) {
            super((AnnotationObject.Builder)b);
            this.description = (String[])CollectionUtils.copyOf((java.lang.Object[])b.description);
            this.externalDocs = b.externalDocs;
            this.name = b.name;
        }

        @Override
        public ExternalDocs externalDocs() {
            return this.externalDocs;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public String[] description() {
            return this.description;
        }
    }
}

