/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.util.graph;

import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.util.graph.Findable;

public class FindableCollection
implements Findable {
    private Collection<Triple> triples;

    public FindableCollection(Collection<Triple> triples) {
        this.triples = triples;
    }

    @Override
    public Iterator<Triple> find(Node s, Node p, Node o) {
        Node _s = FindableCollection.anyAsNull(s);
        Node _p = FindableCollection.anyAsNull(p);
        Node _o = FindableCollection.anyAsNull(o);
        return Iter.filter(this.triples.iterator(), t -> FindableCollection.matches(t, _s, _p, _o));
    }

    private static Node anyAsNull(Node n) {
        return n == Node.ANY ? null : n;
    }

    static boolean matches(Triple t, Node s, Node p, Node o) {
        if (s != null && !Objects.equals(s, t.getSubject())) {
            return false;
        }
        if (p != null && !Objects.equals(p, t.getPredicate())) {
            return false;
        }
        return o == null || Objects.equals(o, t.getObject());
    }

    @Override
    public boolean contains(Node s, Node p, Node o) {
        Node _s = FindableCollection.anyAsNull(s);
        Node _p = FindableCollection.anyAsNull(p);
        Node _o = FindableCollection.anyAsNull(o);
        for (Triple t : this.triples) {
            if (!FindableCollection.matches(t, _s, _p, _o)) continue;
            return true;
        }
        return false;
    }
}

