/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.store;

import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.GraphView;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.tdb2.store.DatasetGraphSwitchable;
import org.apache.jena.tdb2.store.DatasetGraphTDB;
import org.apache.jena.util.iterator.ExtendedIterator;

public class GraphViewSwitchable
extends GraphView {
    private final DatasetGraphSwitchable dsgx;

    public static GraphViewSwitchable createDefaultGraphSwitchable(DatasetGraphSwitchable dsg) {
        return new GraphViewSwitchable(dsg, Quad.defaultGraphNodeGenerated);
    }

    public static GraphView createNamedGraphSwitchable(DatasetGraphSwitchable dsg, Node graphIRI) {
        return new GraphViewSwitchable(dsg, graphIRI);
    }

    public static GraphViewSwitchable createUnionGraphSwitchable(DatasetGraphSwitchable dsg) {
        return new GraphViewSwitchable(dsg, Quad.unionGraph);
    }

    protected DatasetGraphSwitchable getx() {
        return this.dsgx;
    }

    protected GraphViewSwitchable(DatasetGraphSwitchable dsg, Node gn) {
        super((DatasetGraph)dsg, gn);
        this.dsgx = dsg;
    }

    public DatasetGraphSwitchable getDataset() {
        return this.getx();
    }

    public Graph getBaseGraph() {
        if (this.getGraphName() == null) {
            return this.getDSG().getDefaultGraph();
        }
        return this.getDSG().getGraph(this.getGraphName());
    }

    protected int graphBaseSize() {
        return this.getBaseGraph().size();
    }

    public void clear() {
        this.getBaseGraph().clear();
    }

    public void sync() {
    }

    protected ExtendedIterator<Triple> graphBaseFind(Node s, Node p, Node o) {
        return this.getBaseGraph().find(s, p, o);
    }

    private DatasetGraphTDB getDSG() {
        return (DatasetGraphTDB)this.getx().get();
    }
}

