/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.sse;

import java.io.OutputStream;
import java.util.Map;
import java.util.Set;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.graph.NodeConst;
import org.apache.jena.sparql.serializer.SerializationContext;
import org.apache.jena.sparql.sse.Item;
import org.apache.jena.sparql.sse.ItemList;
import org.apache.jena.sparql.sse.ItemVisitor;
import org.apache.jena.sparql.util.FmtUtils;

public class ItemWriter {
    public static boolean includeBase = false;
    private static boolean CloseSameLine = true;
    private static final boolean writeQuotedTriplesAsNodes = true;

    public static void write(OutputStream out, Item item) {
        IndentedWriter iw = new IndentedWriter(out);
        ItemWriter.write(iw, item, null);
        iw.ensureStartOfLine();
        iw.flush();
    }

    public static void write(IndentedWriter out, Item item, SerializationContext sCxt) {
        ItemWriter.writeInline(out, item, sCxt);
    }

    private static void writeInline(IndentedWriter out, Item item, SerializationContext sCxt) {
        Print pv = new Print(out, sCxt);
        pv.startPrint();
        item.visit(pv);
        pv.finishPrint();
    }

    private static void writeFn(IndentedWriter out, Item item, SerializationContext sCxt) {
        Print pv = new Print(out, sCxt);
        pv.startPrint();
        item.visit(pv);
        pv.finishPrint();
    }

    public static void write(IndentedWriter out, Node node, SerializationContext sCxt) {
        ItemWriter.writeNode(out, node, sCxt);
    }

    private static void writeNode(IndentedWriter out, Node node, SerializationContext sCxt) {
        if (node.isTripleTerm()) {
            Triple t = node.getTriple();
            out.print("<<( ");
            ItemWriter.writeNode(out, t.getSubject(), sCxt);
            out.print(" ");
            ItemWriter.writeNode(out, t.getPredicate(), sCxt);
            out.print(" ");
            ItemWriter.writeNode(out, t.getObject(), sCxt);
            out.print(" )>>");
            return;
        }
        if (Node.ANY.equals((Object)node)) {
            out.print("ANY");
            return;
        }
        if (NodeConst.TRUE.equals((Object)node)) {
            out.print("true");
            return;
        }
        if (NodeConst.FALSE.equals((Object)node)) {
            out.print("false");
            return;
        }
        out.print(FmtUtils.stringForNode(node, sCxt));
    }

    private static class Print
    implements ItemVisitor {
        IndentedWriter out;
        SerializationContext sCxt;
        boolean doneBase = false;
        boolean donePrefix = false;
        private static Set<String> oneLineTags = Set.of("tripleterm", "triple");

        Print(IndentedWriter out, SerializationContext sCxt) {
            if (sCxt == null) {
                sCxt = new SerializationContext();
            }
            this.out = out;
            this.sCxt = sCxt;
        }

        void startPrint() {
        }

        void writeContext() {
            if (this.sCxt != null) {
                PrefixMapping pmap;
                if (includeBase && this.sCxt.getBaseIRI() != null) {
                    this.out.print("(base ");
                    this.out.println(FmtUtils.stringForURI(this.sCxt.getBaseIRI()));
                    this.doneBase = true;
                    this.out.incIndent();
                }
                if ((pmap = this.sCxt.getPrefixMapping()) != null) {
                    Map pm = pmap.getNsPrefixMap();
                    boolean bl = this.donePrefix = pm.size() != 0;
                    if (pm.size() != 0) {
                        this.out.println("(prefix");
                        this.out.incIndent();
                        this.printPrefixes(pm, this.out);
                        this.out.println();
                    }
                }
            }
        }

        void finishPrint() {
            if (this.doneBase) {
                this.out.print(")");
                this.out.decIndent();
            }
            if (this.donePrefix) {
                this.out.print(")");
                this.out.decIndent();
            }
        }

        @Override
        public void visit(Item item, Node node) {
            ItemWriter.writeNode(this.out, node, this.sCxt);
        }

        @Override
        public void visit(Item item, String symbol) {
            this.out.print(symbol);
        }

        @Override
        public void visit(Item item, ItemList list) {
            this.out.print("(");
            boolean listMode = false;
            for (Item subItem : list) {
                if (Print.oneLine(subItem)) continue;
                listMode = true;
                break;
            }
            if (listMode) {
                this.printAsList(list);
            } else {
                this.printOneLine(list);
            }
        }

        private static boolean oneLine(Item item) {
            if (!item.isList()) {
                return true;
            }
            ItemList list = item.getList();
            if (list.isEmpty()) {
                return true;
            }
            Item item0 = list.getFirst();
            if (!item0.isSymbol()) {
                return false;
            }
            String symbol = item0.getSymbol();
            return oneLineTags.contains(symbol);
        }

        @Override
        public void visitNil(Item item) {
            this.out.print("nil");
        }

        private void printAsList(ItemList list) {
            boolean first = true;
            int indentlevel = this.out.getUnitIndent();
            if (list.size() >= 1 && list.get(0).isList()) {
                indentlevel = 1;
            }
            for (Item subItem : list) {
                if (!first) {
                    this.out.println();
                }
                subItem.visit(this);
                if (first) {
                    this.out.incIndent(indentlevel);
                }
                first = false;
            }
            if (!first) {
                this.out.decIndent(indentlevel);
            }
            if (!CloseSameLine) {
                this.out.println();
            }
            this.out.print(")");
        }

        private void printOneLine(ItemList list) {
            boolean first = true;
            for (Item subItem : list) {
                if (!first) {
                    this.out.print(" ");
                }
                first = false;
                subItem.visit(this);
            }
            this.out.print(")");
        }

        private void printPrefixes(Map<String, String> map, IndentedWriter out) {
            if (map.size() == 0) {
                return;
            }
            out.print("( ");
            out.incIndent(2);
            boolean first = true;
            for (String s : map.keySet()) {
                if (!first) {
                    out.println();
                }
                first = false;
                String k = s;
                String v = map.get(k);
                out.print("(");
                out.print(k);
                out.print(':');
                out.print(' ', 6 - k.length());
                out.print(FmtUtils.stringForURI(v));
                out.print(")");
            }
            out.decIndent(2);
            out.print(")");
        }
    }
}

