/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.jena.atlas.lib.SetUtils;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.TextDirection;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.impl.Util;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFWrapper;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.nodevalue.NodeFunctions;
import org.apache.jena.sparql.util.EqualityTest;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.WrappedIterator;

public class NodeUtils {
    public static EqualityTest sameNode = (n1, n2) -> Objects.equals(n1, n2);
    public static EqualityTest sameRdfTerm = (n1, n2) -> NodeFunctions.sameTerm(n1, n2);
    public static EqualityTest sameValue = (n1, n2) -> {
        if (Objects.equals(n1, n2)) {
            return true;
        }
        if (!n1.isLiteral() || !n2.isLiteral()) {
            return false;
        }
        NodeValue nv1 = NodeValue.makeNode(n1);
        NodeValue nv2 = NodeValue.makeNode(n2);
        try {
            return NodeValue.sameValueAs(nv1, nv2);
        }
        catch (ExprEvalException ex) {
            return false;
        }
    };
    static Set<RDFDatatype> numericDatatypes = new HashSet<RDFDatatype>();

    public static Node asNode(String iri) {
        return NodeFactory.createURI((String)iri);
    }

    public static boolean hasLang(Node node) {
        if (!node.isLiteral()) {
            return false;
        }
        String x = node.getLiteralLanguage();
        if (x == null) {
            return false;
        }
        return !x.equals("");
    }

    public static boolean hasLangDir(Node node) {
        if (!node.isLiteral()) {
            return false;
        }
        TextDirection textDir = node.getLiteralBaseDirection();
        return textDir != null;
    }

    public static String stringLiteral(Node literal) {
        if (!literal.isLiteral()) {
            return null;
        }
        RDFDatatype dType = literal.getLiteralDatatype();
        String langTag = literal.getLiteralLanguage();
        if (langTag != null && !langTag.equals("")) {
            return literal.getLiteralLexicalForm();
        }
        if (dType == null || dType.equals(XSDDatatype.XSDstring)) {
            return literal.getLiteralLexicalForm();
        }
        return null;
    }

    public static Node nullToAny(Node n) {
        return n == null ? Node.ANY : n;
    }

    public static Iterator<String> nodesToURIs(Iterator<Node> iter) {
        ExtendedIterator eIter = WrappedIterator.create(iter);
        ExtendedIterator conv = eIter.filterKeep(Node::isURI).mapWith(Node::getURI);
        return conv;
    }

    public static Set<Node> convertToSetNodes(Collection<String> namedGraphs) {
        Set nodes = SetUtils.toSet(namedGraphs.stream().map(NodeFactory::createURI));
        return nodes;
    }

    public static Set<Node> convertToSetNodes(String ... namedGraphs) {
        return NodeUtils.convertToSetNodes(Arrays.asList(namedGraphs));
    }

    public static List<Node> convertToListNodes(String ... namedGraphs) {
        return NodeUtils.convertToListNodes(Arrays.asList(namedGraphs));
    }

    public static List<Node> convertToListNodes(List<String> namedGraphs) {
        List<Node> nodes = namedGraphs.stream().map(NodeFactory::createURI).toList();
        return nodes;
    }

    public static boolean isXSDNumeric(Node node) {
        if (!node.isLiteral()) {
            return false;
        }
        return numericDatatypes.contains(node.getLiteralDatatype());
    }

    public static boolean isSimpleString(Node n) {
        return Util.isSimpleString((Node)n);
    }

    public static boolean isLangString(Node n) {
        return Util.isLangString((Node)n);
    }

    public static boolean isDirLangString(Node n) {
        return Util.isDirLangString((Node)n);
    }

    public static boolean isValidAsRDF(Node s, Node p, Node o) {
        if (s == null || !s.isBlank() && !s.isURI()) {
            return false;
        }
        if (p == null || !p.isURI()) {
            return false;
        }
        return o != null && (o.isBlank() || o.isURI() || o.isLiteral() || o.isTripleTerm());
    }

    public static boolean isValidAsRDF(Node g, Node s, Node p, Node o) {
        if (g == null || !g.isURI() && !g.isBlank()) {
            return false;
        }
        return NodeUtils.isValidAsRDF(s, p, o);
    }

    public static StreamRDF removeGeneralizedRDF(StreamRDF data) {
        return new StreamRDFWrapper(data){

            @Override
            public void quad(Quad quad) {
                if (!NodeUtils.isValidAsRDF(quad.getGraph(), quad.getSubject(), quad.getPredicate(), quad.getObject())) {
                    return;
                }
                super.quad(quad);
            }

            @Override
            public void triple(Triple triple) {
                if (!NodeUtils.isValidAsRDF(triple.getSubject(), triple.getPredicate(), triple.getObject())) {
                    return;
                }
                super.triple(triple);
            }
        };
    }

    static {
        numericDatatypes.add((RDFDatatype)XSDDatatype.XSDdecimal);
        numericDatatypes.add((RDFDatatype)XSDDatatype.XSDinteger);
        numericDatatypes.add((RDFDatatype)XSDDatatype.XSDlong);
        numericDatatypes.add((RDFDatatype)XSDDatatype.XSDint);
        numericDatatypes.add((RDFDatatype)XSDDatatype.XSDshort);
        numericDatatypes.add((RDFDatatype)XSDDatatype.XSDbyte);
        numericDatatypes.add((RDFDatatype)XSDDatatype.XSDnonPositiveInteger);
        numericDatatypes.add((RDFDatatype)XSDDatatype.XSDnegativeInteger);
        numericDatatypes.add((RDFDatatype)XSDDatatype.XSDnonNegativeInteger);
        numericDatatypes.add((RDFDatatype)XSDDatatype.XSDpositiveInteger);
        numericDatatypes.add((RDFDatatype)XSDDatatype.XSDunsignedLong);
        numericDatatypes.add((RDFDatatype)XSDDatatype.XSDunsignedInt);
        numericDatatypes.add((RDFDatatype)XSDDatatype.XSDunsignedShort);
        numericDatatypes.add((RDFDatatype)XSDDatatype.XSDdouble);
        numericDatatypes.add((RDFDatatype)XSDDatatype.XSDfloat);
    }
}

