/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.extensions;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.ExtendedRequest;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.extensions.ExtOpMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ValidateTOTPPasswordExtendedRequest
extends ExtendedRequest {
    @NotNull
    public static final String VALIDATE_TOTP_PASSWORD_REQUEST_OID = "1.3.6.1.4.1.30221.2.6.15";
    private static final byte TYPE_USER_DN = -128;
    private static final byte TYPE_TOTP_PASSWORD = -127;
    private static final long serialVersionUID = -4610279612454559569L;
    @NotNull
    private final String userDN;
    @NotNull
    private final String totpPassword;

    public ValidateTOTPPasswordExtendedRequest(@NotNull String userDN, @NotNull String totpPassword, Control ... controls) {
        super(VALIDATE_TOTP_PASSWORD_REQUEST_OID, ValidateTOTPPasswordExtendedRequest.encodeValue(userDN, totpPassword), controls);
        Validator.ensureNotNull(userDN);
        Validator.ensureNotNull(totpPassword);
        this.userDN = userDN;
        this.totpPassword = totpPassword;
    }

    public ValidateTOTPPasswordExtendedRequest(@NotNull ExtendedRequest extendedRequest) throws LDAPException {
        super(extendedRequest);
        ASN1OctetString value = extendedRequest.getValue();
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_VALIDATE_TOTP_REQUEST_MISSING_VALUE.get());
        }
        try {
            ASN1Element[] elements = ASN1Sequence.decodeAsSequence(value.getValue()).elements();
            this.userDN = ASN1OctetString.decodeAsOctetString(elements[0]).stringValue();
            this.totpPassword = ASN1OctetString.decodeAsOctetString(elements[1]).stringValue();
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_VALIDATE_TOTP_REQUEST_MALFORMED_VALUE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @NotNull
    private static ASN1OctetString encodeValue(@NotNull String userDN, @NotNull String totpPassword) {
        return new ASN1OctetString(new ASN1Sequence(new ASN1OctetString(-128, userDN), new ASN1OctetString(-127, totpPassword)).encode());
    }

    @NotNull
    public String getUserDN() {
        return this.userDN;
    }

    @NotNull
    public String getTOTPPassword() {
        return this.totpPassword;
    }

    @Override
    @NotNull
    public ValidateTOTPPasswordExtendedRequest duplicate() {
        return this.duplicate(this.getControls());
    }

    @Override
    @NotNull
    public ValidateTOTPPasswordExtendedRequest duplicate(@Nullable Control[] controls) {
        ValidateTOTPPasswordExtendedRequest r = new ValidateTOTPPasswordExtendedRequest(this.userDN, this.totpPassword, controls);
        r.setResponseTimeoutMillis(this.getResponseTimeoutMillis(null));
        return r;
    }

    @Override
    @NotNull
    public String getExtendedRequestName() {
        return ExtOpMessages.INFO_EXTENDED_REQUEST_NAME_VALIDATE_TOTP.get();
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("ValidateTOTPPasswordExtendedRequest(userDN='");
        buffer.append(this.userDN);
        buffer.append('\'');
        Control[] controls = this.getControls();
        if (controls.length > 0) {
            buffer.append(", controls={");
            for (int i = 0; i < controls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(controls[i]);
            }
            buffer.append('}');
        }
        buffer.append(')');
    }
}

