/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.expression.visitor.predicate;

import com.google.common.base.Preconditions;
import java.util.LinkedHashSet;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.expression.ExpressionType;
import org.apache.iotdb.db.queryengine.plan.expression.binary.CompareBinaryExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.EqualToExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.GreaterEqualExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.GreaterThanExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.LessEqualExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.LessThanExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.LogicAndExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.LogicOrExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.NonEqualExpression;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.ConstantOperand;
import org.apache.iotdb.db.queryengine.plan.expression.other.GroupByTimeExpression;
import org.apache.iotdb.db.queryengine.plan.expression.ternary.BetweenExpression;
import org.apache.iotdb.db.queryengine.plan.expression.unary.InExpression;
import org.apache.iotdb.db.queryengine.plan.expression.unary.IsNullExpression;
import org.apache.iotdb.db.queryengine.plan.expression.unary.LikeExpression;
import org.apache.iotdb.db.queryengine.plan.expression.unary.LogicNotExpression;
import org.apache.iotdb.db.queryengine.plan.expression.unary.RegularExpression;
import org.apache.iotdb.db.queryengine.plan.expression.visitor.predicate.PredicateVisitor;
import org.apache.iotdb.db.utils.TimestampPrecisionUtils;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.filter.basic.Filter;
import org.apache.tsfile.read.filter.factory.FilterFactory;
import org.apache.tsfile.read.filter.factory.TimeFilterApi;
import org.apache.tsfile.utils.TimeDuration;

public class ConvertPredicateToTimeFilterVisitor
extends PredicateVisitor<Filter, Void> {
    @Override
    public Filter visitInExpression(InExpression inExpression, Void context) {
        Expression expression = inExpression.getExpression();
        Preconditions.checkArgument((boolean)expression.getExpressionType().equals((Object)ExpressionType.TIMESTAMP));
        LinkedHashSet<String> values = inExpression.getValues();
        if (values.size() == 1) {
            Expression rewrittenExpression = this.rewriteInExpressionToEqual(inExpression);
            return rewrittenExpression.accept(this, context);
        }
        LinkedHashSet<Long> longValues = new LinkedHashSet<Long>();
        for (String value : values) {
            longValues.add(Long.parseLong(value));
        }
        return inExpression.isNotIn() ? TimeFilterApi.notIn(longValues) : TimeFilterApi.in(longValues);
    }

    private Expression rewriteInExpressionToEqual(InExpression inExpression) {
        LinkedHashSet<String> values = inExpression.getValues();
        if (inExpression.isNotIn()) {
            return new NonEqualExpression(inExpression.getExpression(), new ConstantOperand(TSDataType.INT64, (String)values.iterator().next()));
        }
        return new EqualToExpression(inExpression.getExpression(), new ConstantOperand(TSDataType.INT64, (String)values.iterator().next()));
    }

    @Override
    public Filter visitIsNullExpression(IsNullExpression isNullExpression, Void context) {
        throw new UnsupportedOperationException("TIMESTAMP does not support IS NULL/IS NOT NULL");
    }

    @Override
    public Filter visitLikeExpression(LikeExpression likeExpression, Void context) {
        throw new UnsupportedOperationException("TIMESTAMP does not support LIKE/NOT LIKE");
    }

    @Override
    public Filter visitRegularExpression(RegularExpression regularExpression, Void context) {
        throw new UnsupportedOperationException("TIMESTAMP does not support REGEXP/NOT REGEXP");
    }

    @Override
    public Filter visitLogicNotExpression(LogicNotExpression logicNotExpression, Void context) {
        throw new IllegalArgumentException("This predicate contains a not! Did you forget to run this predicate through PredicateRemoveNotRewriter? ");
    }

    @Override
    public Filter visitLogicAndExpression(LogicAndExpression logicAndExpression, Void context) {
        return FilterFactory.and((Filter)logicAndExpression.getLeftExpression().accept(this, context), (Filter)logicAndExpression.getRightExpression().accept(this, context));
    }

    @Override
    public Filter visitLogicOrExpression(LogicOrExpression logicOrExpression, Void context) {
        return FilterFactory.or((Filter)logicOrExpression.getLeftExpression().accept(this, context), (Filter)logicOrExpression.getRightExpression().accept(this, context));
    }

    @Override
    public Filter visitEqualToExpression(EqualToExpression equalToExpression, Void context) {
        return this.visitCompareBinaryExpression((CompareBinaryExpression)equalToExpression, context);
    }

    @Override
    public Filter visitNonEqualExpression(NonEqualExpression nonEqualExpression, Void context) {
        return this.visitCompareBinaryExpression((CompareBinaryExpression)nonEqualExpression, context);
    }

    @Override
    public Filter visitGreaterThanExpression(GreaterThanExpression greaterThanExpression, Void context) {
        return this.visitCompareBinaryExpression((CompareBinaryExpression)greaterThanExpression, context);
    }

    @Override
    public Filter visitGreaterEqualExpression(GreaterEqualExpression greaterEqualExpression, Void context) {
        return this.visitCompareBinaryExpression((CompareBinaryExpression)greaterEqualExpression, context);
    }

    @Override
    public Filter visitLessThanExpression(LessThanExpression lessThanExpression, Void context) {
        return this.visitCompareBinaryExpression((CompareBinaryExpression)lessThanExpression, context);
    }

    @Override
    public Filter visitLessEqualExpression(LessEqualExpression lessEqualExpression, Void context) {
        return this.visitCompareBinaryExpression((CompareBinaryExpression)lessEqualExpression, context);
    }

    @Override
    public Filter visitCompareBinaryExpression(CompareBinaryExpression comparisonExpression, Void context) {
        Expression leftExpression = comparisonExpression.getLeftExpression();
        Expression rightExpression = comparisonExpression.getRightExpression();
        ExpressionType expressionType = comparisonExpression.getExpressionType();
        if (leftExpression.getExpressionType().equals((Object)ExpressionType.TIMESTAMP)) {
            return this.constructCompareFilter(expressionType, rightExpression);
        }
        return this.constructCompareFilter(CompareBinaryExpression.flipType(expressionType), leftExpression);
    }

    private Filter constructCompareFilter(ExpressionType expressionType, Expression constantExpression) {
        long value = Long.parseLong(((ConstantOperand)constantExpression).getValueString());
        switch (expressionType) {
            case EQUAL_TO: {
                return TimeFilterApi.eq((long)value);
            }
            case NON_EQUAL: {
                return TimeFilterApi.notEq((long)value);
            }
            case GREATER_THAN: {
                return TimeFilterApi.gt((long)value);
            }
            case GREATER_EQUAL: {
                return TimeFilterApi.gtEq((long)value);
            }
            case LESS_THAN: {
                return TimeFilterApi.lt((long)value);
            }
            case LESS_EQUAL: {
                return TimeFilterApi.ltEq((long)value);
            }
        }
        throw new UnsupportedOperationException(String.format("Unsupported expression type %s", new Object[]{expressionType}));
    }

    @Override
    public Filter visitBetweenExpression(BetweenExpression betweenExpression, Void context) {
        long minValue;
        Expression firstExpression = betweenExpression.getFirstExpression();
        Expression secondExpression = betweenExpression.getSecondExpression();
        Expression thirdExpression = betweenExpression.getThirdExpression();
        boolean isNot = betweenExpression.isNotBetween();
        if (firstExpression.getExpressionType().equals((Object)ExpressionType.TIMESTAMP)) {
            long maxValue;
            long minValue2 = Long.parseLong(((ConstantOperand)secondExpression).getValueString());
            if (minValue2 == (maxValue = Long.parseLong(((ConstantOperand)thirdExpression).getValueString()))) {
                return isNot ? TimeFilterApi.notEq((long)minValue2) : TimeFilterApi.eq((long)minValue2);
            }
            return isNot ? TimeFilterApi.notBetween((long)minValue2, (long)maxValue) : TimeFilterApi.between((long)minValue2, (long)maxValue);
        }
        if (secondExpression.getExpressionType().equals((Object)ExpressionType.TIMESTAMP)) {
            long maxValue;
            long value = Long.parseLong(((ConstantOperand)firstExpression).getValueString());
            Preconditions.checkArgument((value <= (maxValue = Long.parseLong(((ConstantOperand)thirdExpression).getValueString())) ? 1 : 0) != 0, (Object)String.format("Predicate [%s] should be simplified in previous step", betweenExpression));
            return isNot ? TimeFilterApi.gt((long)value) : TimeFilterApi.ltEq((long)value);
        }
        long value = Long.parseLong(((ConstantOperand)firstExpression).getValueString());
        Preconditions.checkArgument((value >= (minValue = Long.parseLong(((ConstantOperand)secondExpression).getValueString())) ? 1 : 0) != 0, (Object)String.format("Predicate [%s] should be simplified in previous step", betweenExpression));
        return isNot ? TimeFilterApi.lt((long)value) : TimeFilterApi.gtEq((long)value);
    }

    @Override
    public Filter visitGroupByTimeExpression(GroupByTimeExpression groupByTimeExpression, Void context) {
        long startTime = groupByTimeExpression.getStartTime();
        long endTime = groupByTimeExpression.getEndTime();
        TimeDuration interval = groupByTimeExpression.getInterval();
        TimeDuration slidingStep = groupByTimeExpression.getSlidingStep();
        if (interval.containsMonth() || slidingStep.containsMonth()) {
            return TimeFilterApi.groupByMonth((long)startTime, (long)endTime, (TimeDuration)interval, (TimeDuration)slidingStep, (TimeZone)TimeZone.getTimeZone("+00:00"), (TimeUnit)TimestampPrecisionUtils.currPrecision);
        }
        return TimeFilterApi.groupBy((long)startTime, (long)endTime, (long)interval.nonMonthDuration, (long)slidingStep.nonMonthDuration);
    }
}

