/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.sink.protocol.pipeconsensus.handler;

import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.client.async.AsyncPipeConsensusServiceClient;
import org.apache.iotdb.commons.utils.RetryUtils;
import org.apache.iotdb.consensus.pipe.thrift.TPipeConsensusTransferReq;
import org.apache.iotdb.consensus.pipe.thrift.TPipeConsensusTransferResp;
import org.apache.iotdb.db.pipe.consensus.metric.PipeConsensusSinkMetrics;
import org.apache.iotdb.db.pipe.event.common.deletion.PipeDeleteDataNodeEvent;
import org.apache.iotdb.db.pipe.sink.protocol.pipeconsensus.PipeConsensusAsyncSink;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.thrift.TException;
import org.apache.thrift.async.AsyncMethodCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeConsensusDeleteEventHandler
implements AsyncMethodCallback<TPipeConsensusTransferResp> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeConsensusDeleteEventHandler.class);
    private final PipeDeleteDataNodeEvent event;
    private final TPipeConsensusTransferReq req;
    private final PipeConsensusAsyncSink connector;
    private final PipeConsensusSinkMetrics metric;
    private final long createTime;

    public PipeConsensusDeleteEventHandler(PipeDeleteDataNodeEvent event, TPipeConsensusTransferReq req, PipeConsensusAsyncSink connector, PipeConsensusSinkMetrics metric) {
        this.event = event;
        this.req = req;
        this.connector = connector;
        this.metric = metric;
        this.createTime = System.nanoTime();
    }

    public void transfer(AsyncPipeConsensusServiceClient client) throws TException {
        client.pipeConsensusTransfer(this.req, (AsyncMethodCallback)this);
    }

    public void onComplete(TPipeConsensusTransferResp response) {
        if (response == null) {
            this.onError((Exception)((Object)new PipeException("TPipeConsensusTransferResp is null")));
            return;
        }
        TSStatus status = response.getStatus();
        try {
            if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode() && status.getCode() != TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode()) {
                this.connector.statusHandler().handle(status, status.getMessage(), this.event.toString());
            }
            this.event.decreaseReferenceCount(PipeConsensusDeleteEventHandler.class.getName(), true);
            if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                LOGGER.info("DeleteNodeTransfer: no.{} event successfully processed!", (Object)this.event.getReplicateIndexForIoTV2());
            }
            this.connector.removeEventFromBuffer(this.event);
            long duration = System.nanoTime() - this.createTime;
            this.metric.recordConnectorWalTransferTimer(duration);
        }
        catch (Exception e) {
            this.onError(e);
        }
    }

    public void onError(Exception e) {
        LOGGER.warn("Failed to transfer PipeDeleteNodeEvent {} (committer key={}, replicate index={}).", new Object[]{this.event.coreReportMessage(), this.event.getCommitterKey(), this.event.getReplicateIndexForIoTV2(), e});
        if (RetryUtils.needRetryWithIncreasingInterval((Exception)e)) {
            if (this.event.getRetryInterval() << 2 <= 0L) {
                this.event.setRetryInterval(20000L);
            } else {
                this.event.setRetryInterval(Math.min(20000L, this.event.getRetryInterval() << 2));
            }
        }
        this.connector.addFailureEventToRetryQueue(this.event);
        this.metric.recordRetryCounter();
    }
}

