/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils.sort;

import org.apache.iotdb.db.queryengine.exception.MemoryNotEnoughException;

public class SortBufferManager {
    private final int maxTsBlockSizeInBytes;
    private final long sortBufferSize;
    private long bufferUsed;
    private final long bufferSizeForOneBranch;
    private final long bufferAvailableForAllBranch;
    private long readerBuffer = 0L;
    private long branchNum = 0L;

    public SortBufferManager(int maxTsBlockSizeInBytes, long sortBufferSize) {
        this.maxTsBlockSizeInBytes = maxTsBlockSizeInBytes;
        this.sortBufferSize = sortBufferSize;
        this.bufferAvailableForAllBranch = sortBufferSize - (long)maxTsBlockSizeInBytes;
        this.bufferSizeForOneBranch = maxTsBlockSizeInBytes;
        this.bufferUsed = maxTsBlockSizeInBytes;
    }

    public void allocateOneSortBranch() {
        boolean success = this.allocate(this.bufferSizeForOneBranch);
        if (!success) {
            throw new MemoryNotEnoughException("Not enough memory for sorting");
        }
        ++this.branchNum;
    }

    private boolean check(long size) {
        return this.bufferUsed + size < this.sortBufferSize;
    }

    public boolean allocate(long size) {
        if (this.check(size)) {
            this.bufferUsed += size;
            return true;
        }
        return false;
    }

    public void releaseOneSortBranch() {
        --this.branchNum;
        if (this.branchNum != 0L) {
            this.readerBuffer = this.bufferAvailableForAllBranch / this.branchNum;
        }
    }

    public long getReaderBufferAvailable() {
        if (this.readerBuffer != 0L) {
            return this.readerBuffer;
        }
        this.readerBuffer = this.bufferAvailableForAllBranch / this.branchNum;
        return this.readerBuffer;
    }

    public int getMaxTsBlockSizeInBytes() {
        return this.maxTsBlockSizeInBytes;
    }

    public long getSortBufferSize() {
        return this.sortBufferSize;
    }
}

