/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.expression.visitor;

import java.util.List;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.schema.column.ColumnHeader;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.queryengine.plan.analyze.ExpressionUtils;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.LeafOperand;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.queryengine.plan.expression.visitor.ReconstructVisitor;

public class BindTypeForTimeSeriesOperandVisitor
extends ReconstructVisitor<List<ColumnHeader>> {
    @Override
    public Expression visitTimeSeriesOperand(TimeSeriesOperand predicate, List<ColumnHeader> columnHeaders) {
        String oldPathString = predicate.getPath().getFullPath();
        for (ColumnHeader columnHeader : columnHeaders) {
            if (!oldPathString.equalsIgnoreCase(columnHeader.getColumnName())) continue;
            try {
                return ExpressionUtils.reconstructTimeSeriesOperand(predicate, new PartialPath(columnHeader.getColumnName()), columnHeader.getColumnType());
            }
            catch (IllegalPathException e) {
                throw new SemanticException(e);
            }
        }
        throw new SemanticException(String.format("please ensure input[%s] is correct", oldPathString));
    }

    @Override
    public Expression visitLeafOperand(LeafOperand leafOperand, List<ColumnHeader> context) {
        return leafOperand;
    }
}

