/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cglib.core;

import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import org.springframework.asm.Type;
import org.springframework.cglib.core.Predicate;
import org.springframework.cglib.core.TypeUtils;

public class VisibilityPredicate
implements Predicate {
    private boolean protectedOk;
    private String pkg;
    private boolean samePackageOk;

    public VisibilityPredicate(Class source, boolean protectedOk) {
        this.protectedOk = protectedOk;
        this.samePackageOk = source.getClassLoader() != null;
        this.pkg = TypeUtils.getPackageName(Type.getType(source));
    }

    public boolean evaluate(Object arg) {
        Member member2 = (Member)arg;
        int mod2 = member2.getModifiers();
        if (Modifier.isPrivate(mod2)) {
            return false;
        }
        if (Modifier.isPublic(mod2)) {
            return true;
        }
        if (Modifier.isProtected(mod2) && this.protectedOk) {
            return true;
        }
        return this.samePackageOk && this.pkg.equals(TypeUtils.getPackageName(Type.getType(member2.getDeclaringClass())));
    }
}

