/*
 * Decompiled with CFR 0.152.
 */
package org.apache.toree.interpreter.broker;

import java.io.OutputStream;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.toree.interpreter.broker.BrokerCode;
import org.apache.toree.interpreter.broker.BrokerException;
import org.apache.toree.interpreter.broker.BrokerPromise;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.mutable.Map;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005=g\u0001B\u0001\u0003\u00015\u00111B\u0011:pW\u0016\u00148\u000b^1uK*\u00111\u0001B\u0001\u0007EJ|7.\u001a:\u000b\u0005\u00151\u0011aC5oi\u0016\u0014\bO]3uKJT!a\u0002\u0005\u0002\u000bQ|'/Z3\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\t\u0001a\u0002\u0005\u0002\u0010%5\t\u0001CC\u0001\u0012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0002C\u0001\u0004B]f\u0014VM\u001a\u0005\t+\u0001\u0011)\u0019!C\u0005-\u0005iQ.\u0019=Rk\u0016,X\rZ\"pI\u0016,\u0012a\u0006\t\u0003\u001faI!!\u0007\t\u0003\u0007%sG\u000f\u0003\u0005\u001c\u0001\t\u0005\t\u0015!\u0003\u0018\u00039i\u0017\r_)vKV,GmQ8eK\u0002BQ!\b\u0001\u0005\u0002y\ta\u0001P5oSRtDCA\u0010\"!\t\u0001\u0003!D\u0001\u0003\u0011\u0015)B\u00041\u0001\u0018\u0011\u001d\u0019\u0003A1A\u0005\n\u0011\na\u0001\\8hO\u0016\u0014X#A\u0013\u0011\u0005\u0019JS\"A\u0014\u000b\u0005!R\u0011!B:mMRR\u0017B\u0001\u0016(\u0005\u0019aunZ4fe\"1A\u0006\u0001Q\u0001\n\u0015\nq\u0001\\8hO\u0016\u0014\b\u0005C\u0004/\u0001\u0001\u0007I\u0011B\u0018\u0002\u0011}K7OU3bIf,\u0012\u0001\r\t\u0003\u001fEJ!A\r\t\u0003\u000f\t{w\u000e\\3b]\"9A\u0007\u0001a\u0001\n\u0013)\u0014\u0001D0jgJ+\u0017\rZ=`I\u0015\fHC\u0001\u001c:!\tyq'\u0003\u00029!\t!QK\\5u\u0011\u001dQ4'!AA\u0002A\n1\u0001\u001f\u00132\u0011\u0019a\u0004\u0001)Q\u0005a\u0005Iq,[:SK\u0006$\u0017\u0010\t\u0015\u0003wy\u0002\"aD \n\u0005\u0001\u0003\"\u0001\u0003<pY\u0006$\u0018\u000e\\3\t\u000f\t\u0003!\u0019!C\t\u0007\u0006I1m\u001c3f#V,W/Z\u000b\u0002\tB\u0019QI\u0013'\u000e\u0003\u0019S!a\u0012%\u0002\tU$\u0018\u000e\u001c\u0006\u0002\u0013\u0006!!.\u0019<b\u0013\tYeIA\u0003Rk\u0016,X\r\u0005\u0002!\u001b&\u0011aJ\u0001\u0002\u000b\u0005J|7.\u001a:D_\u0012,\u0007B\u0002)\u0001A\u0003%A)\u0001\u0006d_\u0012,\u0017+^3vK\u0002BqA\u0015\u0001C\u0002\u0013E1+\u0001\u0006qe>l\u0017n]3NCB,\u0012\u0001\u0016\t\u0005+jc\u0016/D\u0001W\u0015\t9\u0006,A\u0004nkR\f'\r\\3\u000b\u0005e\u0003\u0012AC2pY2,7\r^5p]&\u00111L\u0016\u0002\u0004\u001b\u0006\u0004\bCA/n\u001d\tq6N\u0004\u0002`U:\u0011\u0001-\u001b\b\u0003C\"t!AY4\u000f\u0005\r4W\"\u00013\u000b\u0005\u0015d\u0011A\u0002\u001fs_>$h(C\u0001\f\u0013\tI!\"\u0003\u0002\b\u0011%\u0011QAB\u0005\u0003\u0007\u0011I!\u0001\u001c\u0002\u0002\u0017\t\u0013xn[3s)f\u0004Xm]\u0005\u0003]>\u0014aaQ8eK&#\u0017B\u00019\u0003\u0005M\u0011%o\\6feRK\b/Z:Qe>4\u0018\u000eZ3s!\t\u0001#/\u0003\u0002t\u0005\ti!I]8lKJ\u0004&o\\7jg\u0016Da!\u001e\u0001!\u0002\u0013!\u0016a\u00039s_6L7/Z'ba\u0002Bqa\u001e\u0001C\u0002\u0013E\u00010A\u000bpkR\u0004X\u000f\u001e*fgVdGo\u0015;sK\u0006lW*\u00199\u0016\u0003e\u0004B!\u0016.]uB\u0019qb_?\n\u0005q\u0004\"AB(qi&|g\u000eE\u0002\u007f\u0003;q1a`A\f\u001d\u0011\t\t!a\u0005\u000f\t\u0005\r\u0011Q\u0002\b\u0005\u0003\u000b\tIAD\u0002d\u0003\u000fI\u0011!E\u0005\u0004\u0003\u0017\u0001\u0012!\u0002;p_2\u001c\u0018\u0002BA\b\u0003#\t1A\\:d\u0015\r\tY\u0001E\u0005\u0004\u000b\u0005U!\u0002BA\b\u0003#IA!!\u0007\u0002\u001c\u00059\u0001/Y2lC\u001e,'bA\u0003\u0002\u0016%!\u0011qDA\u0011\u00051yU\u000f\u001e9viN#(/Z1n\u0015\u0011\tI\"a\u0007\t\u000f\u0005\u0015\u0002\u0001)A\u0005s\u00061r.\u001e;qkR\u0014Vm];miN#(/Z1n\u001b\u0006\u0004\b\u0005C\u0004\u0002*\u0001!\t!a\u000b\u0002\u0011A,8\u000f[\"pI\u0016$b!!\f\u0002@\u0005%\u0003CBA\u0018\u0003k\tI$\u0004\u0002\u00022)\u0019\u00111\u0007\t\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0003\u00028\u0005E\"A\u0002$viV\u0014X\rE\u0002^\u0003wI1!!\u0010p\u0005-\u0019u\u000eZ3SKN,H\u000e^:\t\u0011\u0005\u0005\u0013q\u0005a\u0001\u0003\u0007\nAaY8eKB\u0019Q,!\u0012\n\u0007\u0005\u001dsN\u0001\u0003D_\u0012,\u0007\"CA&\u0003O\u0001\n\u00111\u0001{\u0003IyW\u000f\u001e9viJ+7/\u001e7u'R\u0014X-Y7\t\u000f\u0005=\u0003\u0001\"\u0001\u0002R\u0005Q1/\u001a8e\u001fV$\b/\u001e;\u0015\u000bY\n\u0019&!\u001a\t\u0011\u0005U\u0013Q\na\u0001\u0003/\naaY8eK&#\u0007\u0003BA-\u0003?r1aDA.\u0013\r\ti\u0006E\u0001\u0007!J,G-\u001a4\n\t\u0005\u0005\u00141\r\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005u\u0003\u0003\u0003\u0005\u0002h\u00055\u0003\u0019AA,\u0003\u0019yW\u000f\u001e9vi\"9\u00111\u000e\u0001\u0005\u0002\u00055\u0014a\u0004;pi\u0006d\u0017+^3vK\u0012\u001cu\u000eZ3\u0015\u0003]Aq!!\u001d\u0001\t\u0003\t\u0019(\u0001\u0005oKb$8i\u001c3f)\u0005a\u0005BBA<\u0001\u0011\u0005q&A\u0004jgJ+\u0017\rZ=\t\u000f\u0005m\u0004\u0001\"\u0001\u0002~\u0005IQ.\u0019:l%\u0016\fG-\u001f\u000b\u0002m!9\u0011\u0011\u0011\u0001\u0005\u0002\u0005\r\u0015aC7be.\u001cVoY2fgN$RANAC\u0003\u000fCq!!\u0016\u0002\u0000\u0001\u0007A\f\u0003\u0005\u0002h\u0005}\u0004\u0019AA\u001d\u0011\u001d\t\t\t\u0001C\u0001\u0003\u0017#2ANAG\u0011\u001d\t)&!#A\u0002qCq!!%\u0001\t\u0003\t\u0019*A\u0006nCJ\\g)Y5mkJ,G#\u0002\u001c\u0002\u0016\u0006]\u0005bBA+\u0003\u001f\u0003\r\u0001\u0018\u0005\t\u0003O\ny\t1\u0001\u0002:!9\u0011\u0011\u0013\u0001\u0005\u0002\u0005mEc\u0001\u001c\u0002\u001e\"9\u0011QKAM\u0001\u0004a\u0006bBAQ\u0001\u0011\u0005\u00111U\u0001\u0006e\u0016\u001cX\r\u001e\u000b\u0006m\u0005\u0015\u0016\u0011\u0016\u0005\t\u0003O\u000by\n1\u0001\u0002X\u00059Q.Z:tC\u001e,\u0007\"CAV\u0003?\u0003\n\u00111\u00011\u0003Ai\u0017M]6BY2\f5OR1jYV\u0014X\rC\u0005\u00020\u0002\t\n\u0011\"\u0001\u00022\u0006\u0011\u0002/^:i\u0007>$W\r\n3fM\u0006,H\u000e\u001e\u00133+\t\t\u0019LK\u0002{\u0003k[#!a.\u0011\t\u0005e\u00161Y\u0007\u0003\u0003wSA!!0\u0002@\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u0003\u0004\u0012AC1o]>$\u0018\r^5p]&!\u0011QYA^\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\n\u0003\u0013\u0004\u0011\u0013!C\u0001\u0003\u0017\fqB]3tKR$C-\u001a4bk2$HEM\u000b\u0003\u0003\u001bT3\u0001MA[\u0001")
public class BrokerState {
    private final int maxQueuedCode;
    private final Logger logger;
    private volatile boolean _isReady;
    private final Queue<BrokerCode> codeQueue;
    private final Map<String, BrokerPromise> promiseMap;
    private final Map<String, Option<OutputStream>> outputResultStreamMap;

    private int maxQueuedCode() {
        return this.maxQueuedCode;
    }

    private Logger logger() {
        return this.logger;
    }

    private boolean _isReady() {
        return this._isReady;
    }

    private void _isReady_$eq(boolean x$1) {
        this._isReady = x$1;
    }

    public Queue<BrokerCode> codeQueue() {
        return this.codeQueue;
    }

    public Map<String, BrokerPromise> promiseMap() {
        return this.promiseMap;
    }

    public Map<String, Option<OutputStream>> outputResultStreamMap() {
        return this.outputResultStreamMap;
    }

    public synchronized Future<String> pushCode(String code, Option<OutputStream> outputResultStream) {
        if (this.codeQueue().size() >= this.maxQueuedCode()) {
            throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Code limit of ", " has been reached!"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.maxQueuedCode())})));
        }
        Promise codeExecutionPromise = Promise$.MODULE$.apply();
        String uniqueId = UUID.randomUUID().toString();
        BrokerCode brokerCode = new BrokerCode(uniqueId, code);
        BrokerPromise brokerPromise = new BrokerPromise(uniqueId, (Promise<String>)codeExecutionPromise);
        this.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Queueing '", "' with id '", "' to run with broker"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{code, uniqueId})));
        this.codeQueue().add(brokerCode);
        this.promiseMap().put((Object)brokerPromise.codeId(), (Object)brokerPromise);
        this.outputResultStreamMap().put((Object)brokerPromise.codeId(), outputResultStream);
        return codeExecutionPromise.future();
    }

    public Option<OutputStream> pushCode$default$2() {
        return None$.MODULE$;
    }

    public void sendOutput(String codeId, String output) {
        Option option2 = (Option)this.outputResultStreamMap().get((Object)codeId).get();
        if (option2 instanceof Some) {
            Some some2 = (Some)option2;
            OutputStream outputStream2 = (OutputStream)some2.x();
            outputStream2.write(output.getBytes());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            this.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Output stream is invalid for codeId ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{codeId})));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public int totalQueuedCode() {
        return this.codeQueue().size();
    }

    /*
     * WARNING - void declaration
     */
    public BrokerCode nextCode() {
        void var1_1;
        BrokerCode brokerCode = this.codeQueue().poll();
        if (brokerCode != null) {
            this.logger().trace(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sending ", " to Broker runner"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{brokerCode})));
        }
        return var1_1;
    }

    public boolean isReady() {
        return this._isReady();
    }

    public void markReady() {
        this._isReady_$eq(true);
    }

    public void markSuccess(String codeId, String output) {
        this.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Received success for code with id '", "': ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{codeId, output})));
        this.promiseMap().remove((Object)codeId).foreach((Function1)new Serializable(this, output){
            public static final long serialVersionUID = 0L;
            private final String output$1;

            public final Promise<String> apply(BrokerPromise x$1) {
                return x$1.promise().success((Object)this.output$1);
            }
            {
                this.output$1 = output$1;
            }
        });
    }

    public void markSuccess(String codeId) {
        this.markSuccess(codeId, "");
    }

    public void markFailure(String codeId, String output) {
        this.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Received failure for code with id '", "': ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{codeId, output})));
        this.promiseMap().remove((Object)codeId).foreach((Function1)new Serializable(this, output){
            public static final long serialVersionUID = 0L;
            private final String output$2;

            public final Promise<String> apply(BrokerPromise x$2) {
                return x$2.promise().failure((Throwable)new BrokerException(this.output$2));
            }
            {
                this.output$2 = output$2;
            }
        });
    }

    public void markFailure(String codeId) {
        this.markFailure(codeId, "");
    }

    public void reset(String message, boolean markAllAsFailure) {
        Queue<BrokerCode> queue = this.codeQueue();
        synchronized (queue) {
            Map<String, BrokerPromise> map2 = this.promiseMap();
            synchronized (map2) {
                this.codeQueue().clear();
                this.promiseMap().foreach((Function1)new Serializable(this, message, markAllAsFailure){
                    public static final long serialVersionUID = 0L;
                    private final String message$1;
                    private final boolean markAllAsFailure$1;

                    public final Promise<String> apply(Tuple2<String, BrokerPromise> x0$1) {
                        Tuple2<String, BrokerPromise> tuple23 = x0$1;
                        if (tuple23 != null) {
                            BrokerPromise codePromise = (BrokerPromise)tuple23._2();
                            Promise promise = this.markAllAsFailure$1 ? codePromise.promise().failure((Throwable)new BrokerException(this.message$1)) : codePromise.promise().success((Object)this.message$1);
                            return promise;
                        }
                        throw new MatchError(tuple23);
                    }
                    {
                        this.message$1 = message$1;
                        this.markAllAsFailure$1 = markAllAsFailure$1;
                    }
                });
                this.promiseMap().clear();
                return;
            }
        }
    }

    public boolean reset$default$2() {
        return true;
    }

    public BrokerState(int maxQueuedCode) {
        this.maxQueuedCode = maxQueuedCode;
        this.logger = LoggerFactory.getLogger(this.getClass());
        this._isReady = false;
        this.codeQueue = new ConcurrentLinkedQueue<BrokerCode>();
        this.promiseMap = (Map)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(new ConcurrentHashMap()).asScala();
        this.outputResultStreamMap = (Map)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(new ConcurrentHashMap()).asScala();
    }
}

