/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util.functional;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.util.functional.CallableRaisingIOE;
import org.apache.hadoop.util.functional.FunctionRaisingIOE;

@InterfaceAudience.Private
public final class FunctionalIO {
    private FunctionalIO() {
    }

    public static <T> T uncheckIOExceptions(CallableRaisingIOE<T> call) {
        return call.unchecked();
    }

    public static <T> Supplier<T> toUncheckedIOExceptionSupplier(CallableRaisingIOE<T> call) {
        return call::unchecked;
    }

    public static <T> T extractIOExceptions(Supplier<T> call) throws IOException {
        try {
            return call.get();
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    public static <T, R> Function<T, R> toUncheckedFunction(FunctionRaisingIOE<T, R> fun) {
        return fun::unchecked;
    }
}

