/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.admin.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import org.apache.polaris.core.admin.model.AuthenticationParameters;

@ApiModel(description="Polaris does not explicitly accept any authentication parameters for the connection. Authentication parameters found in the environment and/or configuration files will be used for this connection.")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ImplicitAuthenticationParameters
extends AuthenticationParameters {
    @JsonCreator
    public ImplicitAuthenticationParameters(@JsonProperty(value="authenticationType") AuthenticationParameters.AuthenticationTypeEnum authenticationType) {
        super(authenticationType);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(AuthenticationParameters.AuthenticationTypeEnum authenticationType) {
        return new Builder(authenticationType);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImplicitAuthenticationParameters implicitAuthenticationParameters = (ImplicitAuthenticationParameters)o;
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ImplicitAuthenticationParameters {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class Builder {
        private AuthenticationParameters.AuthenticationTypeEnum authenticationType;

        private Builder() {
        }

        private Builder(AuthenticationParameters.AuthenticationTypeEnum authenticationType) {
            this.authenticationType = authenticationType;
        }

        public Builder setAuthenticationType(AuthenticationParameters.AuthenticationTypeEnum authenticationType) {
            this.authenticationType = authenticationType;
            return this;
        }

        public ImplicitAuthenticationParameters build() {
            ImplicitAuthenticationParameters inst = new ImplicitAuthenticationParameters(this.authenticationType);
            return inst;
        }
    }
}

