/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.secrets;

import io.smallrye.common.annotation.Identifier;
import jakarta.enterprise.context.ApplicationScoped;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.polaris.core.context.RealmContext;
import org.apache.polaris.core.secrets.UnsafeInMemorySecretsManager;
import org.apache.polaris.core.secrets.UserSecretsManager;
import org.apache.polaris.core.secrets.UserSecretsManagerFactory;

@ApplicationScoped
@Identifier(value="in-memory")
public class UnsafeInMemorySecretsManagerFactory
implements UserSecretsManagerFactory {
    private final Map<String, UserSecretsManager> cachedSecretsManagers = new ConcurrentHashMap<String, UserSecretsManager>();

    public UserSecretsManager getOrCreateUserSecretsManager(RealmContext realmContext) {
        return this.cachedSecretsManagers.computeIfAbsent(realmContext.getRealmIdentifier(), key -> new UnsafeInMemorySecretsManager());
    }
}

