/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.catalog.iceberg;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import jakarta.annotation.Nullable;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.lang.reflect.Field;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.iceberg.BaseMetadataTable;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.BaseTransaction;
import org.apache.iceberg.MetadataUpdate;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.SnapshotRef;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.UpdateRequirement;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.SupportsNamespaces;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.catalog.ViewCatalog;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.exceptions.NoSuchNamespaceException;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.exceptions.NoSuchViewException;
import org.apache.iceberg.rest.requests.CreateNamespaceRequest;
import org.apache.iceberg.rest.requests.CreateTableRequest;
import org.apache.iceberg.rest.requests.CreateViewRequest;
import org.apache.iceberg.rest.requests.RegisterTableRequest;
import org.apache.iceberg.rest.requests.RenameTableRequest;
import org.apache.iceberg.rest.requests.UpdateNamespacePropertiesRequest;
import org.apache.iceberg.rest.requests.UpdateTableRequest;
import org.apache.iceberg.rest.responses.CreateNamespaceResponse;
import org.apache.iceberg.rest.responses.GetNamespaceResponse;
import org.apache.iceberg.rest.responses.ImmutableLoadViewResponse;
import org.apache.iceberg.rest.responses.ListNamespacesResponse;
import org.apache.iceberg.rest.responses.ListTablesResponse;
import org.apache.iceberg.rest.responses.LoadTableResponse;
import org.apache.iceberg.rest.responses.LoadViewResponse;
import org.apache.iceberg.rest.responses.UpdateNamespacePropertiesResponse;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.Pair;
import org.apache.iceberg.util.PropertyUtil;
import org.apache.iceberg.util.SnapshotUtil;
import org.apache.iceberg.util.Tasks;
import org.apache.iceberg.view.BaseView;
import org.apache.iceberg.view.SQLViewRepresentation;
import org.apache.iceberg.view.View;
import org.apache.iceberg.view.ViewBuilder;
import org.apache.iceberg.view.ViewMetadata;
import org.apache.iceberg.view.ViewOperations;
import org.apache.iceberg.view.ViewRepresentation;
import org.apache.polaris.core.config.FeatureConfiguration;
import org.apache.polaris.core.config.PolarisConfiguration;
import org.apache.polaris.core.config.RealmConfig;
import org.apache.polaris.service.catalog.iceberg.CatalogHandlerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class CatalogHandlerUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(CatalogHandlerUtils.class);
    private static final Schema EMPTY_SCHEMA = new Schema(new Types.NestedField[0]);
    private static final String INITIAL_PAGE_TOKEN = "";
    private static final String CONFLICT_RESOLUTION_ACTION = "polaris.internal.conflict-resolution.by-operation-type.replace";
    private static final Field LAST_SEQUENCE_NUMBER_FIELD;
    private final int maxCommitRetries;
    private final boolean rollbackCompactionEnabled;

    @Inject
    public CatalogHandlerUtils(RealmConfig realmConfig) {
        this((Integer)realmConfig.getConfig((PolarisConfiguration)FeatureConfiguration.ICEBERG_COMMIT_MAX_RETRIES), (Boolean)realmConfig.getConfig((PolarisConfiguration)FeatureConfiguration.ICEBERG_ROLLBACK_COMPACTION_ON_CONFLICTS));
    }

    @VisibleForTesting
    public CatalogHandlerUtils(int maxCommitRetries, boolean rollbackCompactionEnabled) {
        this.maxCommitRetries = maxCommitRetries;
        this.rollbackCompactionEnabled = rollbackCompactionEnabled;
    }

    private <T> Pair<List<T>, String> paginate(List<T> list, @Nullable String pageToken, @Nullable Integer pageSize) {
        int pageStart;
        if (pageToken == null) {
            return Pair.of(list, null);
        }
        int n = pageStart = INITIAL_PAGE_TOKEN.equals(pageToken) ? 0 : Integer.parseInt(pageToken);
        if (pageStart >= list.size()) {
            return Pair.of(Collections.emptyList(), null);
        }
        pageSize = pageSize == null ? list.size() : pageSize.intValue();
        int end = Math.min(pageStart + pageSize, list.size());
        List<T> subList = list.subList(pageStart, end);
        String nextPageToken = end >= list.size() ? null : String.valueOf(end);
        return Pair.of(subList, (Object)nextPageToken);
    }

    public ListNamespacesResponse listNamespaces(SupportsNamespaces catalog, Namespace parent) {
        List results = parent.isEmpty() ? catalog.listNamespaces() : catalog.listNamespaces(parent);
        return ListNamespacesResponse.builder().addAll((Collection)results).build();
    }

    public ListNamespacesResponse listNamespaces(SupportsNamespaces catalog, Namespace parent, String pageToken, Integer pageSize) {
        List results = parent.isEmpty() ? catalog.listNamespaces() : catalog.listNamespaces(parent);
        Pair page = this.paginate(results, pageToken, pageSize);
        return ListNamespacesResponse.builder().addAll((Collection)page.first()).nextPageToken((String)page.second()).build();
    }

    public CreateNamespaceResponse createNamespace(SupportsNamespaces catalog, CreateNamespaceRequest request) {
        Namespace namespace = request.namespace();
        catalog.createNamespace(namespace, request.properties());
        return CreateNamespaceResponse.builder().withNamespace(namespace).setProperties(catalog.loadNamespaceMetadata(namespace)).build();
    }

    public void namespaceExists(SupportsNamespaces catalog, Namespace namespace) {
        if (!catalog.namespaceExists(namespace)) {
            throw new NoSuchNamespaceException("Namespace does not exist: %s", new Object[]{namespace});
        }
    }

    public GetNamespaceResponse loadNamespace(SupportsNamespaces catalog, Namespace namespace) {
        Map properties = catalog.loadNamespaceMetadata(namespace);
        return GetNamespaceResponse.builder().withNamespace(namespace).setProperties(properties).build();
    }

    public void dropNamespace(SupportsNamespaces catalog, Namespace namespace) {
        boolean dropped = catalog.dropNamespace(namespace);
        if (!dropped) {
            throw new NoSuchNamespaceException("Namespace does not exist: %s", new Object[]{namespace});
        }
    }

    public UpdateNamespacePropertiesResponse updateNamespaceProperties(SupportsNamespaces catalog, Namespace namespace, UpdateNamespacePropertiesRequest request) {
        request.validate();
        HashSet removals = Sets.newHashSet((Iterable)request.removals());
        Map updates = request.updates();
        Map startProperties = catalog.loadNamespaceMetadata(namespace);
        Sets.SetView missing = Sets.difference((Set)removals, startProperties.keySet());
        if (!updates.isEmpty()) {
            catalog.setProperties(namespace, updates);
        }
        if (!removals.isEmpty()) {
            catalog.removeProperties(namespace, (Set)removals);
        }
        return UpdateNamespacePropertiesResponse.builder().addMissing((Collection)missing).addUpdated(updates.keySet()).addRemoved((Collection)Sets.difference((Set)removals, (Set)missing)).build();
    }

    public ListTablesResponse listTables(Catalog catalog, Namespace namespace) {
        List idents = catalog.listTables(namespace);
        return ListTablesResponse.builder().addAll((Collection)idents).build();
    }

    public ListTablesResponse listTables(Catalog catalog, Namespace namespace, String pageToken, Integer pageSize) {
        List results = catalog.listTables(namespace);
        Pair page = this.paginate(results, pageToken, pageSize);
        return ListTablesResponse.builder().addAll((Collection)page.first()).nextPageToken((String)page.second()).build();
    }

    public LoadTableResponse stageTableCreate(Catalog catalog, Namespace namespace, CreateTableRequest request) {
        request.validate();
        TableIdentifier ident = TableIdentifier.of((Namespace)namespace, (String)request.name());
        if (catalog.tableExists(ident)) {
            throw new AlreadyExistsException("Table already exists: %s", new Object[]{ident});
        }
        HashMap properties = Maps.newHashMap();
        properties.put("created-at", OffsetDateTime.now(ZoneOffset.UTC).toString());
        properties.putAll(request.properties());
        String location = request.location() != null ? request.location() : catalog.buildTable(ident, request.schema()).withPartitionSpec(request.spec()).withSortOrder(request.writeOrder()).withProperties((Map)properties).createTransaction().table().location();
        TableMetadata metadata = TableMetadata.newTableMetadata((Schema)request.schema(), (PartitionSpec)(request.spec() != null ? request.spec() : PartitionSpec.unpartitioned()), (SortOrder)(request.writeOrder() != null ? request.writeOrder() : SortOrder.unsorted()), (String)location, (Map)properties);
        return LoadTableResponse.builder().withTableMetadata(metadata).build();
    }

    public LoadTableResponse createTable(Catalog catalog, Namespace namespace, CreateTableRequest request) {
        request.validate();
        TableIdentifier ident = TableIdentifier.of((Namespace)namespace, (String)request.name());
        Table table = catalog.buildTable(ident, request.schema()).withLocation(request.location()).withPartitionSpec(request.spec()).withSortOrder(request.writeOrder()).withProperties(request.properties()).create();
        if (table instanceof BaseTable) {
            BaseTable baseTable = (BaseTable)table;
            return LoadTableResponse.builder().withTableMetadata(baseTable.operations().current()).build();
        }
        throw new IllegalStateException("Cannot wrap catalog that does not produce BaseTable");
    }

    public LoadTableResponse registerTable(Catalog catalog, Namespace namespace, RegisterTableRequest request) {
        request.validate();
        TableIdentifier identifier = TableIdentifier.of((Namespace)namespace, (String)request.name());
        Table table = catalog.registerTable(identifier, request.metadataLocation());
        if (table instanceof BaseTable) {
            BaseTable baseTable = (BaseTable)table;
            return LoadTableResponse.builder().withTableMetadata(baseTable.operations().current()).build();
        }
        throw new IllegalStateException("Cannot wrap catalog that does not produce BaseTable");
    }

    public void dropTable(Catalog catalog, TableIdentifier ident) {
        boolean dropped = catalog.dropTable(ident, false);
        if (!dropped) {
            throw new NoSuchTableException("Table does not exist: %s", new Object[]{ident});
        }
    }

    public void purgeTable(Catalog catalog, TableIdentifier ident) {
        boolean dropped = catalog.dropTable(ident, true);
        if (!dropped) {
            throw new NoSuchTableException("Table does not exist: %s", new Object[]{ident});
        }
    }

    public void tableExists(Catalog catalog, TableIdentifier ident) {
        boolean exists = catalog.tableExists(ident);
        if (!exists) {
            throw new NoSuchTableException("Table does not exist: %s", new Object[]{ident});
        }
    }

    public LoadTableResponse loadTable(Catalog catalog, TableIdentifier ident) {
        Table table = catalog.loadTable(ident);
        if (table instanceof BaseTable) {
            BaseTable baseTable = (BaseTable)table;
            return LoadTableResponse.builder().withTableMetadata(baseTable.operations().current()).build();
        }
        if (table instanceof BaseMetadataTable) {
            throw new NoSuchTableException("Table does not exist: %s", new Object[]{ident.toString()});
        }
        throw new IllegalStateException("Cannot wrap catalog that does not produce BaseTable");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public LoadTableResponse updateTable(Catalog catalog, TableIdentifier ident, UpdateTableRequest request) {
        TableMetadata finalMetadata;
        if (this.isCreate(request)) {
            Transaction transaction = catalog.buildTable(ident, EMPTY_SCHEMA).createOrReplaceTransaction();
            if (!(transaction instanceof BaseTransaction)) throw new IllegalStateException("Cannot wrap catalog that does not produce BaseTransaction");
            BaseTransaction baseTransaction = (BaseTransaction)transaction;
            finalMetadata = this.create(baseTransaction.underlyingOps(), request);
            return LoadTableResponse.builder().withTableMetadata(finalMetadata).build();
        } else {
            Table table = catalog.loadTable(ident);
            if (!(table instanceof BaseTable)) throw new IllegalStateException("Cannot wrap catalog that does not produce BaseTable");
            BaseTable baseTable = (BaseTable)table;
            TableOperations ops = baseTable.operations();
            finalMetadata = this.commit(ops, request);
        }
        return LoadTableResponse.builder().withTableMetadata(finalMetadata).build();
    }

    public void renameTable(Catalog catalog, RenameTableRequest request) {
        catalog.renameTable(request.source(), request.destination());
    }

    private boolean isCreate(UpdateTableRequest request) {
        boolean isCreate = request.requirements().stream().anyMatch(UpdateRequirement.AssertTableDoesNotExist.class::isInstance);
        if (isCreate) {
            List invalidRequirements = request.requirements().stream().filter(req -> !(req instanceof UpdateRequirement.AssertTableDoesNotExist)).collect(Collectors.toList());
            Preconditions.checkArgument((boolean)invalidRequirements.isEmpty(), (String)"Invalid create requirements: %s", invalidRequirements);
        }
        return isCreate;
    }

    private TableMetadata create(TableOperations ops, UpdateTableRequest request) {
        request.requirements().forEach(requirement -> requirement.validate(ops.current()));
        Optional<Integer> formatVersion = request.updates().stream().filter(update -> update instanceof MetadataUpdate.UpgradeFormatVersion).map(update -> ((MetadataUpdate.UpgradeFormatVersion)update).formatVersion()).findFirst();
        TableMetadata.Builder builder = formatVersion.map(TableMetadata::buildFromEmpty).orElseGet(TableMetadata::buildFromEmpty);
        request.updates().forEach(update -> update.applyTo(builder));
        ops.commit(null, builder.build());
        return ops.current();
    }

    @VisibleForTesting
    public TableMetadata commit(TableOperations ops, UpdateTableRequest request) {
        AtomicBoolean isRetry = new AtomicBoolean(false);
        try {
            Tasks.foreach((Object[])new TableOperations[]{ops}).retry(this.maxCommitRetries).exponentialBackoff(100L, 60000L, 1800000L, 2.0).onlyRetryOn(CommitFailedException.class).run(taskOps -> {
                TableMetadata base = isRetry.get() ? taskOps.refresh() : taskOps.current();
                TableMetadata.Builder metadataBuilder = TableMetadata.buildFrom((TableMetadata)base);
                TableMetadata newBase = base;
                try {
                    request.requirements().forEach(requirement -> requirement.validate(base));
                }
                catch (CommitFailedException e) {
                    if (!this.rollbackCompactionEnabled) {
                        throw new ValidationFailureException(e);
                    }
                    LOGGER.debug("Attempting to Rollback replace operations for table={}, with current-snapshot-id={}", (Object)base.uuid(), (Object)base.currentSnapshot().snapshotId());
                    UpdateRequirement.AssertRefSnapshotID assertRefSnapshotId = this.findAssertRefSnapshotID(request);
                    MetadataUpdate.SetSnapshotRef setSnapshotRef = this.findSetSnapshotRefUpdate(request);
                    if (assertRefSnapshotId == null || setSnapshotRef == null) {
                        LOGGER.debug("Giving up on Rollback replace operations for table={}, with current-snapshot-id={}, as operation doesn't attempts to add a single snapshot", (Object)base.uuid(), (Object)base.currentSnapshot().snapshotId());
                        throw new ValidationFailureException(e);
                    }
                    long expectedCurrentSnapshotId = assertRefSnapshotId.snapshotId();
                    MetadataUpdate.AddSnapshot snapshotToBeAdded = this.findAddSnapshotUpdate(request);
                    if (snapshotToBeAdded == null) {
                        throw new ValidationFailureException(e);
                    }
                    LOGGER.info("Attempting to Rollback replace operation for table={}, with current-snapshot-id={}, to snapshot={}", new Object[]{base.uuid(), base.currentSnapshot().snapshotId(), snapshotToBeAdded.snapshot().snapshotId()});
                    List<MetadataUpdate> metadataUpdates = this.generateUpdatesToRemoveNoopSnapshot(base, expectedCurrentSnapshotId, setSnapshotRef.name());
                    if (metadataUpdates == null || metadataUpdates.isEmpty()) {
                        throw new ValidationFailureException(e);
                    }
                    metadataBuilder.setBranchSnapshot(expectedCurrentSnapshotId, setSnapshotRef.name());
                    metadataUpdates.forEach(update -> update.applyTo(metadataBuilder));
                    newBase = this.setAppropriateLastSeqNumber(metadataBuilder, base.uuid(), base.lastSequenceNumber(), base.snapshot(expectedCurrentSnapshotId).sequenceNumber()).build();
                    LOGGER.info("Successfully roll-backed replace operation for table={}, with current-snapshot-id={}, to snapshot={}", new Object[]{base.uuid(), base.currentSnapshot().snapshotId(), newBase.currentSnapshot().snapshotId()});
                }
                try {
                    TableMetadata baseWithRemovedSnaps = newBase;
                    request.requirements().forEach(requirement -> requirement.validate(baseWithRemovedSnaps));
                }
                catch (CommitFailedException e) {
                    throw new ValidationFailureException(e);
                }
                TableMetadata.Builder newMetadataBuilder = TableMetadata.buildFrom((TableMetadata)newBase);
                request.updates().forEach(update -> update.applyTo(newMetadataBuilder));
                TableMetadata updated = newMetadataBuilder.build();
                if (updated.changes().isEmpty()) {
                    return;
                }
                taskOps.commit(base, updated);
            });
        }
        catch (ValidationFailureException e) {
            throw e.wrapped();
        }
        return ops.current();
    }

    private UpdateRequirement.AssertRefSnapshotID findAssertRefSnapshotID(UpdateTableRequest request) {
        UpdateRequirement.AssertRefSnapshotID assertRefSnapshotID = null;
        int total = 0;
        for (UpdateRequirement requirement : request.requirements()) {
            if (!(requirement instanceof UpdateRequirement.AssertRefSnapshotID)) continue;
            UpdateRequirement.AssertRefSnapshotID assertRefSnapshotIDReq = (UpdateRequirement.AssertRefSnapshotID)requirement;
            ++total;
            assertRefSnapshotID = assertRefSnapshotIDReq;
        }
        return total != 1 ? null : assertRefSnapshotID;
    }

    private List<MetadataUpdate> generateUpdatesToRemoveNoopSnapshot(TableMetadata base, long expectedCurrentSnapshotId, String updateRefName) {
        HashSet idsToRetain = Sets.newHashSet();
        for (Map.Entry ref : base.refs().entrySet()) {
            String refName = (String)ref.getKey();
            SnapshotRef snapshotRef = (SnapshotRef)ref.getValue();
            if (refName.equals(updateRefName)) continue;
            idsToRetain.add(((SnapshotRef)ref.getValue()).snapshotId());
            for (Snapshot ancestor : SnapshotUtil.ancestorsOf((long)snapshotRef.snapshotId(), arg_0 -> ((TableMetadata)base).snapshot(arg_0))) {
                idsToRetain.add(ancestor.snapshotId());
            }
        }
        ArrayList<MetadataUpdate> updateToRemoveSnapshot = new ArrayList<MetadataUpdate>();
        Long snapshotId = base.ref(updateRefName).snapshotId();
        long expectedSequenceNumber = base.lastSequenceNumber();
        if (expectedSequenceNumber != base.snapshot(snapshotId.longValue()).sequenceNumber()) {
            LOGGER.debug("Giving up rolling back table {} to snapshot {}, ref current snapshot sequence number {} is not equal expected sequence number {}", new Object[]{base.uuid(), snapshotId, base.snapshot(snapshotId.longValue()).sequenceNumber(), expectedSequenceNumber});
            return null;
        }
        LinkedHashSet<Long> snapshotsToRemove = new LinkedHashSet<Long>();
        while (snapshotId != null && !Objects.equals(snapshotId, expectedCurrentSnapshotId)) {
            Snapshot snap = base.snapshot(snapshotId.longValue());
            if (!this.isRollbackSnapshot(snap) || idsToRetain.contains(snapshotId)) {
                LOGGER.debug("Giving up rolling back table {} to snapshot {}, snapshot to be removed referenced by another branch or tag ancestor", (Object)base.uuid(), (Object)snapshotId);
                break;
            }
            snapshotsToRemove.add(snap.snapshotId());
            snapshotId = snap.parentId();
        }
        boolean wasExpectedSnapshotReached = Objects.equals(snapshotId, expectedCurrentSnapshotId);
        updateToRemoveSnapshot.add((MetadataUpdate)new MetadataUpdate.RemoveSnapshots(snapshotsToRemove));
        return wasExpectedSnapshotReached ? updateToRemoveSnapshot : null;
    }

    private boolean isRollbackSnapshot(Snapshot snapshot) {
        return "replace".equals(snapshot.operation()) && PropertyUtil.propertyAsString((Map)snapshot.summary(), (String)CONFLICT_RESOLUTION_ACTION, (String)INITIAL_PAGE_TOKEN).equalsIgnoreCase("rollback");
    }

    private MetadataUpdate.SetSnapshotRef findSetSnapshotRefUpdate(UpdateTableRequest request) {
        int total = 0;
        MetadataUpdate.SetSnapshotRef setSnapshotRefUpdate = null;
        for (MetadataUpdate update : request.updates()) {
            if (!(update instanceof MetadataUpdate.SetSnapshotRef)) continue;
            MetadataUpdate.SetSnapshotRef setSnapshotRefUpd = (MetadataUpdate.SetSnapshotRef)update;
            ++total;
            setSnapshotRefUpdate = setSnapshotRefUpd;
        }
        return total != 1 ? null : setSnapshotRefUpdate;
    }

    private MetadataUpdate.AddSnapshot findAddSnapshotUpdate(UpdateTableRequest request) {
        int total = 0;
        MetadataUpdate.AddSnapshot addSnapshot = null;
        for (MetadataUpdate update : request.updates()) {
            if (!(update instanceof MetadataUpdate.AddSnapshot)) continue;
            MetadataUpdate.AddSnapshot addSnapshotUpd = (MetadataUpdate.AddSnapshot)update;
            ++total;
            addSnapshot = addSnapshotUpd;
        }
        return total != 1 ? null : addSnapshot;
    }

    private TableMetadata.Builder setAppropriateLastSeqNumber(TableMetadata.Builder metadataBuilder, String tableUUID, long currentSequenceNumber, long expectedSequenceNumber) {
        try {
            LAST_SEQUENCE_NUMBER_FIELD.set(metadataBuilder, expectedSequenceNumber);
            LOGGER.info("Setting table uuid:{} last sequence number from:{} to {}", new Object[]{tableUUID, currentSequenceNumber, expectedSequenceNumber});
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
        return metadataBuilder;
    }

    private BaseView asBaseView(View view) {
        Preconditions.checkState((boolean)(view instanceof BaseView), (Object)"Cannot wrap catalog that does not produce BaseView");
        return (BaseView)view;
    }

    public ListTablesResponse listViews(ViewCatalog catalog, Namespace namespace) {
        return ListTablesResponse.builder().addAll((Collection)catalog.listViews(namespace)).build();
    }

    public ListTablesResponse listViews(ViewCatalog catalog, Namespace namespace, String pageToken, Integer pageSize) {
        List results = catalog.listViews(namespace);
        Pair page = this.paginate(results, pageToken, pageSize);
        return ListTablesResponse.builder().addAll((Collection)page.first()).nextPageToken((String)page.second()).build();
    }

    public LoadViewResponse createView(ViewCatalog catalog, Namespace namespace, CreateViewRequest request) {
        request.validate();
        ViewBuilder viewBuilder = ((ViewBuilder)((ViewBuilder)((ViewBuilder)catalog.buildView(TableIdentifier.of((Namespace)namespace, (String)request.name())).withSchema(request.schema())).withProperties(request.properties()).withDefaultNamespace(request.viewVersion().defaultNamespace())).withDefaultCatalog(request.viewVersion().defaultCatalog())).withLocation(request.location());
        Set unsupportedRepresentations = request.viewVersion().representations().stream().filter(r -> !(r instanceof SQLViewRepresentation)).map(ViewRepresentation::type).collect(Collectors.toSet());
        if (!unsupportedRepresentations.isEmpty()) {
            throw new IllegalStateException(String.format("Found unsupported view representations: %s", unsupportedRepresentations));
        }
        request.viewVersion().representations().stream().filter(SQLViewRepresentation.class::isInstance).map(SQLViewRepresentation.class::cast).forEach(r -> viewBuilder.withQuery(r.dialect(), r.sql()));
        View view = viewBuilder.create();
        return this.viewResponse(view);
    }

    private LoadViewResponse viewResponse(View view) {
        ViewMetadata metadata = this.asBaseView(view).operations().current();
        return ImmutableLoadViewResponse.builder().metadata(metadata).metadataLocation(metadata.metadataFileLocation()).build();
    }

    public void viewExists(ViewCatalog catalog, TableIdentifier viewIdentifier) {
        if (!catalog.viewExists(viewIdentifier)) {
            throw new NoSuchViewException("View does not exist: %s", new Object[]{viewIdentifier});
        }
    }

    public LoadViewResponse loadView(ViewCatalog catalog, TableIdentifier viewIdentifier) {
        View view = catalog.loadView(viewIdentifier);
        return this.viewResponse(view);
    }

    public LoadViewResponse updateView(ViewCatalog catalog, TableIdentifier ident, UpdateTableRequest request) {
        View view = catalog.loadView(ident);
        ViewMetadata metadata = this.commit(this.asBaseView(view).operations(), request);
        return ImmutableLoadViewResponse.builder().metadata(metadata).metadataLocation(metadata.metadataFileLocation()).build();
    }

    public void renameView(ViewCatalog catalog, RenameTableRequest request) {
        catalog.renameView(request.source(), request.destination());
    }

    public void dropView(ViewCatalog catalog, TableIdentifier viewIdentifier) {
        boolean dropped = catalog.dropView(viewIdentifier);
        if (!dropped) {
            throw new NoSuchViewException("View does not exist: %s", new Object[]{viewIdentifier});
        }
    }

    protected ViewMetadata commit(ViewOperations ops, UpdateTableRequest request) {
        AtomicBoolean isRetry = new AtomicBoolean(false);
        try {
            Tasks.foreach((Object[])new ViewOperations[]{ops}).retry(this.maxCommitRetries).exponentialBackoff(100L, 60000L, 1800000L, 2.0).onlyRetryOn(CommitFailedException.class).run(taskOps -> {
                ViewMetadata base = isRetry.get() ? taskOps.refresh() : taskOps.current();
                isRetry.set(true);
                try {
                    request.requirements().forEach(requirement -> requirement.validate(base));
                }
                catch (CommitFailedException e) {
                    throw new ValidationFailureException(e);
                }
                ViewMetadata.Builder metadataBuilder = ViewMetadata.buildFrom((ViewMetadata)base);
                request.updates().forEach(update -> update.applyTo(metadataBuilder));
                ViewMetadata updated = metadataBuilder.build();
                if (updated.changes().isEmpty()) {
                    return;
                }
                taskOps.commit(base, updated);
            });
        }
        catch (ValidationFailureException e) {
            throw e.wrapped();
        }
        return ops.current();
    }

    static {
        try {
            LAST_SEQUENCE_NUMBER_FIELD = TableMetadata.Builder.class.getDeclaredField("lastSequenceNumber");
            LAST_SEQUENCE_NUMBER_FIELD.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("Unable to access field", e);
        }
    }

    public CatalogHandlerUtils() {
    }
}

