/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.baserpc.marshaller;

import com.google.protobuf.Message;
import com.google.protobuf.UnknownFieldSet;
import io.grpc.MethodDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import lombok.Generated;
import org.apache.bifromq.basehlc.HLC;
import org.apache.bifromq.baserpc.marshaller.HLCStampedInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HLCStampedMarshaller<T>
implements MethodDescriptor.Marshaller<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HLCStampedMarshaller.class);
    private final MethodDescriptor.Marshaller<T> delegate;

    public HLCStampedMarshaller(MethodDescriptor.Marshaller<T> delegate) {
        this.delegate = delegate;
    }

    public Class<T> getMessageClass() {
        return this.delegate.getClass();
    }

    public InputStream stream(T value) {
        return new HLCStampedInputStream(this.delegate.stream(value));
    }

    public T parse(InputStream stream) {
        if (stream instanceof HLCStampedInputStream) {
            return (T)this.delegate.parse(((HLCStampedInputStream)stream).protoStream());
        }
        PushbackInputStream pis = new PushbackInputStream(stream, 3);
        byte b0 = (byte)pis.read();
        byte b1 = (byte)pis.read();
        byte b2 = (byte)pis.read();
        if (HLCStampedInputStream.HLC_TAG[0] != b0 || HLCStampedInputStream.HLC_TAG[1] != b1 || HLCStampedInputStream.HLC_TAG[2] != b2) {
            pis.unread(b2);
            pis.unread(b1);
            pis.unread(b0);
            Object message = this.delegate.parse((InputStream)pis);
            UnknownFieldSet.Field piggybackField = ((Message)message).getUnknownFields().getField(Short.MAX_VALUE);
            HLC.INST.update(((Long)piggybackField.getFixed64List().get(0)).longValue());
            return (T)message;
        }
        long hlc = 0L;
        for (int i = 0; i < 8; ++i) {
            int b = pis.read();
            if (b == -1) {
                throw new IOException("Unexpected end of stream while reading HLC");
            }
            hlc |= ((long)b & 0xFFL) << i * 8;
        }
        HLC.INST.update(hlc);
        return (T)this.delegate.parse((InputStream)pis);
    }
}

