/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.localengine.rocksdb;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Tags;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.bifromq.basekv.localengine.metrics.IKVSpaceMetric;
import org.apache.bifromq.basekv.localengine.metrics.KVSpaceMeters;
import org.apache.bifromq.basekv.localengine.rocksdb.IWriteStatsRecorder;
import org.apache.bifromq.basekv.localengine.rocksdb.metrics.RocksDBKVSpaceMetric;

class RocksDBKVSpaceCompactionTrigger
implements IWriteStatsRecorder {
    private final AtomicInteger totalKeyCount = new AtomicInteger();
    private final AtomicInteger totalTombstoneKeyCount = new AtomicInteger();
    private final AtomicInteger totalTombstoneRangeCount = new AtomicInteger();
    private final int minTombstoneKeysTrigger;
    private final int minTombstoneRangesTrigger;
    private final double minTombstoneKeysRatioTrigger;
    private final Runnable compactionScheduler;
    private final Gauge totalKeysGauge;
    private final Gauge totalTombstoneKeysGauge;
    private final Gauge totalTombstoneRangesGauge;

    public RocksDBKVSpaceCompactionTrigger(String id, int minTombstoneKeysTrigger, int minTombstoneRangesTrigger, double minTombstoneKeysRatioTrigger, Runnable compactionScheduler, String ... tags) {
        this.minTombstoneKeysTrigger = minTombstoneKeysTrigger;
        this.minTombstoneRangesTrigger = minTombstoneRangesTrigger;
        this.minTombstoneKeysRatioTrigger = minTombstoneKeysRatioTrigger;
        this.compactionScheduler = compactionScheduler;
        Tags metricTags = Tags.of((String[])tags);
        this.totalKeysGauge = KVSpaceMeters.getGauge((String)id, (IKVSpaceMetric)RocksDBKVSpaceMetric.TotalKeysGauge, this.totalKeyCount::get, (Tags)metricTags);
        this.totalTombstoneKeysGauge = KVSpaceMeters.getGauge((String)id, (IKVSpaceMetric)RocksDBKVSpaceMetric.TotalTombstoneKeysGauge, this.totalTombstoneKeyCount::get, (Tags)metricTags);
        this.totalTombstoneRangesGauge = KVSpaceMeters.getGauge((String)id, (IKVSpaceMetric)RocksDBKVSpaceMetric.TotalTombstoneRangesGauge, this.totalTombstoneRangeCount::get, (Tags)metricTags);
    }

    @Override
    public IWriteStatsRecorder.IRecorder newRecorder() {
        return new WriteStatsRecorder();
    }

    @Override
    public void reset() {
        this.totalKeyCount.set(0);
        this.totalTombstoneKeyCount.set(0);
        this.totalTombstoneRangeCount.set(0);
    }

    class WriteStatsRecorder
    implements IWriteStatsRecorder.IRecorder {
        private final AtomicInteger keyCount = new AtomicInteger();
        private final AtomicInteger tombstoneKeyCount = new AtomicInteger();
        private final AtomicInteger tombstoneRangeCount = new AtomicInteger();

        WriteStatsRecorder() {
        }

        @Override
        public void recordPut() {
            this.keyCount.incrementAndGet();
            this.tombstoneKeyCount.incrementAndGet();
        }

        @Override
        public void recordInsert() {
            this.keyCount.incrementAndGet();
        }

        @Override
        public void recordDelete() {
            this.tombstoneKeyCount.incrementAndGet();
        }

        @Override
        public void recordDeleteRange() {
            this.tombstoneRangeCount.incrementAndGet();
        }

        @Override
        public void stop() {
            int totalKeys = RocksDBKVSpaceCompactionTrigger.this.totalKeyCount.addAndGet(this.keyCount.get());
            int totalTombstones = RocksDBKVSpaceCompactionTrigger.this.totalTombstoneKeyCount.addAndGet(this.tombstoneKeyCount.get());
            int totalRangeTombstones = RocksDBKVSpaceCompactionTrigger.this.totalTombstoneRangeCount.addAndGet(this.tombstoneRangeCount.get());
            if (totalRangeTombstones > RocksDBKVSpaceCompactionTrigger.this.minTombstoneRangesTrigger || totalTombstones > RocksDBKVSpaceCompactionTrigger.this.minTombstoneKeysTrigger && (double)totalTombstones / (double)(totalKeys + totalTombstones) >= RocksDBKVSpaceCompactionTrigger.this.minTombstoneKeysRatioTrigger) {
                RocksDBKVSpaceCompactionTrigger.this.compactionScheduler.run();
            }
        }
    }

    public static interface CompactionScheduler {
        public boolean schedule();
    }
}

