/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.storage.pagememory.index.sorted;

import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.Objects;
import org.apache.ignite3.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite3.internal.pagememory.freelist.FreeListImpl;
import org.apache.ignite3.internal.pagememory.util.GradualTask;
import org.apache.ignite3.internal.schema.BinaryTuple;
import org.apache.ignite3.internal.schema.BinaryTuplePrefix;
import org.apache.ignite3.internal.storage.RowId;
import org.apache.ignite3.internal.storage.StorageException;
import org.apache.ignite3.internal.storage.index.IndexRow;
import org.apache.ignite3.internal.storage.index.IndexRowImpl;
import org.apache.ignite3.internal.storage.index.PeekCursor;
import org.apache.ignite3.internal.storage.index.SortedIndexStorage;
import org.apache.ignite3.internal.storage.index.StorageSortedIndexDescriptor;
import org.apache.ignite3.internal.storage.pagememory.index.AbstractPageMemoryIndexStorage;
import org.apache.ignite3.internal.storage.pagememory.index.common.IndexRowKey;
import org.apache.ignite3.internal.storage.pagememory.index.freelist.IndexColumns;
import org.apache.ignite3.internal.storage.pagememory.index.meta.IndexMeta;
import org.apache.ignite3.internal.storage.pagememory.index.meta.IndexMetaTree;
import org.apache.ignite3.internal.storage.pagememory.index.sorted.InsertSortedIndexRowInvokeClosure;
import org.apache.ignite3.internal.storage.pagememory.index.sorted.RemoveSortedIndexRowInvokeClosure;
import org.apache.ignite3.internal.storage.pagememory.index.sorted.SortedIndexRow;
import org.apache.ignite3.internal.storage.pagememory.index.sorted.SortedIndexRowKey;
import org.apache.ignite3.internal.storage.pagememory.index.sorted.SortedIndexTree;
import org.apache.ignite3.internal.storage.util.StorageState;
import org.apache.ignite3.internal.storage.util.StorageUtils;
import org.apache.ignite3.internal.util.Cursor;
import org.jetbrains.annotations.Nullable;

public class PageMemorySortedIndexStorage
extends AbstractPageMemoryIndexStorage<SortedIndexRowKey, SortedIndexRow, SortedIndexTree>
implements SortedIndexStorage {
    @Nullable
    private final StorageSortedIndexDescriptor descriptor;

    public PageMemorySortedIndexStorage(IndexMeta indexMeta, @Nullable StorageSortedIndexDescriptor descriptor, FreeListImpl freeList, SortedIndexTree indexTree, IndexMetaTree indexMetaTree, boolean isVolatile) {
        super(indexMeta, indexTree.partitionId(), indexTree, freeList, indexMetaTree, isVolatile);
        this.descriptor = descriptor;
    }

    @Override
    public StorageSortedIndexDescriptor indexDescriptor() {
        assert (this.descriptor != null) : "This tree must only be used during recovery";
        return this.descriptor;
    }

    @Override
    public Cursor<RowId> get(final BinaryTuple key) throws StorageException {
        return this.busyDataRead(() -> {
            StorageUtils.throwExceptionIfStorageInProgressOfRebalance((StorageState)((Object)((Object)this.state.get())), () -> this.createStorageInfo());
            this.throwExceptionIfIndexIsNotBuilt();
            SortedIndexRow lowerBound = this.toSortedIndexRow(key, this.lowestRowId);
            return new AbstractPageMemoryIndexStorage.ScanCursor<RowId>((SortedIndexRowKey)lowerBound){

                @Override
                protected RowId map(SortedIndexRow value) {
                    return value.rowId();
                }

                @Override
                protected boolean exceedsUpperBound(SortedIndexRow value) {
                    return !Objects.equals(value.indexColumns().valueBuffer(), key.byteBuffer());
                }
            };
        });
    }

    @Override
    public void put(IndexRow row) {
        this.busyNonDataRead(() -> {
            try {
                SortedIndexRow sortedIndexRow = this.toSortedIndexRow(row.indexColumns(), row.rowId());
                SortedIndexTree tree = (SortedIndexTree)this.indexTree;
                InsertSortedIndexRowInvokeClosure insert = new InsertSortedIndexRowInvokeClosure(sortedIndexRow, this.freeList, tree.inlineSize());
                tree.invoke(sortedIndexRow, null, insert);
                return null;
            }
            catch (IgniteInternalCheckedException e) {
                throw new StorageException("Failed to put value into index", (Throwable)e);
            }
        });
    }

    @Override
    public void remove(IndexRow row) {
        this.busyNonDataRead(() -> {
            StorageUtils.throwExceptionIfStorageInProgressOfRebalance((StorageState)((Object)((Object)this.state.get())), () -> this.createStorageInfo());
            try {
                SortedIndexRow sortedIndexRow = this.toSortedIndexRow(row.indexColumns(), row.rowId());
                RemoveSortedIndexRowInvokeClosure remove = new RemoveSortedIndexRowInvokeClosure(sortedIndexRow, this.freeList);
                ((SortedIndexTree)this.indexTree).invoke(sortedIndexRow, null, remove);
                remove.afterCompletion();
                return null;
            }
            catch (IgniteInternalCheckedException e) {
                throw new StorageException("Failed to remove value from index", (Throwable)e);
            }
        });
    }

    @Override
    public PeekCursor<IndexRow> scan(@Nullable BinaryTuplePrefix lowerBound, @Nullable BinaryTuplePrefix upperBound, int flags) {
        return this.scanInternal(lowerBound, upperBound, flags, true);
    }

    @Override
    public Cursor<IndexRow> readOnlyScan(@Nullable BinaryTuplePrefix lowerBound, @Nullable BinaryTuplePrefix upperBound, int flags) {
        return this.busyDataRead(() -> {
            StorageUtils.throwExceptionIfStorageInProgressOfRebalance((StorageState)((Object)((Object)this.state.get())), () -> this.createStorageInfo());
            this.throwExceptionIfIndexIsNotBuilt();
            boolean includeLower = (flags & 1) != 0;
            boolean includeUpper = (flags & 2) != 0;
            SortedIndexRowKey lower = this.createBound(lowerBound, !includeLower);
            SortedIndexRowKey upper = this.createBound(upperBound, includeUpper);
            try {
                Cursor<SortedIndexRow> cursor = ((SortedIndexTree)this.indexTree).find(lower, upper);
                return new ReadOnlyScanCursor(cursor);
            }
            catch (IgniteInternalCheckedException e) {
                throw new StorageException("Couldn't get index tree cursor", (Throwable)e);
            }
        });
    }

    @Override
    public PeekCursor<IndexRow> tolerantScan(@Nullable BinaryTuplePrefix lowerBound, @Nullable BinaryTuplePrefix upperBound, int flags) {
        return this.scanInternal(lowerBound, upperBound, flags, false);
    }

    @Nullable
    private SortedIndexRowKey createBound(@Nullable BinaryTuplePrefix bound, boolean setEqualityFlag) {
        if (bound == null) {
            return null;
        }
        ByteBuffer buffer = bound.byteBuffer();
        if (setEqualityFlag) {
            byte flags = buffer.get(0);
            buffer.put(0, (byte)(flags | 0x10));
        }
        return new SortedIndexRowKey(new IndexColumns(this.partitionId, buffer));
    }

    private SortedIndexRow toSortedIndexRow(BinaryTuple tuple, RowId rowId) {
        return new SortedIndexRow(new IndexColumns(this.partitionId, tuple.byteBuffer()), rowId);
    }

    @Nullable
    private IndexRowImpl toIndexRowImpl(@Nullable SortedIndexRow sortedIndexRow) {
        return sortedIndexRow == null ? null : new IndexRowImpl(new BinaryTuple(this.indexDescriptor().binaryTupleSchema().elementCount(), sortedIndexRow.indexColumns().valueBuffer()), sortedIndexRow.rowId());
    }

    @Override
    protected GradualTask createDestructionTask(int maxWorkUnits) throws IgniteInternalCheckedException {
        return ((SortedIndexTree)this.indexTree).startGradualDestruction(rowKey -> this.removeIndexColumns((SortedIndexRow)rowKey), false, maxWorkUnits);
    }

    private void removeIndexColumns(SortedIndexRow indexRow) {
        if (indexRow.indexColumns().link() != 0L) {
            try {
                this.freeList.removeDataRowByLink(indexRow.indexColumns().link());
            }
            catch (IgniteInternalCheckedException e) {
                throw new StorageException("Cannot destroy sorted index " + this.indexDescriptor().id(), (Throwable)e);
            }
            indexRow.indexColumns().link(0L);
        }
    }

    private PeekCursor<IndexRow> scanInternal(@Nullable BinaryTuplePrefix lowerBound, @Nullable BinaryTuplePrefix upperBound, int flags, boolean onlyBuiltIndex) {
        return this.busyDataRead(() -> {
            StorageUtils.throwExceptionIfStorageInProgressOfRebalance((StorageState)((Object)((Object)this.state.get())), () -> this.createStorageInfo());
            if (onlyBuiltIndex) {
                this.throwExceptionIfIndexIsNotBuilt();
            }
            boolean includeLower = (flags & 1) != 0;
            boolean includeUpper = (flags & 2) != 0;
            SortedIndexRowKey lower = this.createBound(lowerBound, !includeLower);
            final SortedIndexRowKey upper = this.createBound(upperBound, includeUpper);
            return new AbstractPageMemoryIndexStorage.ScanCursor<IndexRow>(lower){
                private final Comparator<ByteBuffer> comparator;
                {
                    super((AbstractPageMemoryIndexStorage)PageMemorySortedIndexStorage.this, (IndexRowKey)lower);
                    this.comparator = ((SortedIndexTree)this.localTree).getBinaryTupleComparator();
                }

                @Override
                public IndexRow map(SortedIndexRow value) {
                    return PageMemorySortedIndexStorage.this.toIndexRowImpl(value);
                }

                @Override
                protected boolean exceedsUpperBound(SortedIndexRow value) {
                    return upper != null && 0 <= this.comparator.compare(value.indexColumns().valueBuffer(), upper.indexColumns().valueBuffer());
                }
            };
        });
    }

    private class ReadOnlyScanCursor
    implements Cursor<IndexRow> {
        private final Cursor<SortedIndexRow> treeCursor;

        private ReadOnlyScanCursor(Cursor<SortedIndexRow> treeCursor) {
            this.treeCursor = treeCursor;
        }

        @Override
        public boolean hasNext() {
            return (Boolean)PageMemorySortedIndexStorage.this.busyDataRead(() -> {
                StorageUtils.throwExceptionIfStorageInProgressOfRebalance((StorageState)((Object)((Object)PageMemorySortedIndexStorage.this.state.get())), () -> PageMemorySortedIndexStorage.this.createStorageInfo());
                return this.treeCursor.hasNext();
            });
        }

        @Override
        public IndexRow next() {
            return (IndexRow)PageMemorySortedIndexStorage.this.busyDataRead(() -> {
                StorageUtils.throwExceptionIfStorageInProgressOfRebalance((StorageState)((Object)((Object)PageMemorySortedIndexStorage.this.state.get())), () -> PageMemorySortedIndexStorage.this.createStorageInfo());
                SortedIndexRow next = (SortedIndexRow)this.treeCursor.next();
                return PageMemorySortedIndexStorage.this.toIndexRowImpl(next);
            });
        }

        @Override
        public void close() {
            this.treeCursor.close();
        }
    }
}

