/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.interop.ImportValueNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.JSException;
import com.oracle.truffle.js.runtime.UserScriptException;
import com.oracle.truffle.js.runtime.interop.InteropFunction;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import java.lang.invoke.VarHandle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@GeneratedBy(value=ImportValueNode.class)
public final class ImportValueNodeGen
extends ImportValueNode
implements Introspection.Provider {
    private static final Uncached UNCACHED = new Uncached();
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    @CompilerDirectives.CompilationFinal
    private int state_0_;
    @Node.Child
    private TruffleString.SwitchEncodingNode switchEncodingNode;
    @Node.Child
    private TruffleString.FromJavaStringNode fromString_fromJavaStringNode_;
    @Node.Child
    private TruffleString.FromCodePointNode fromChar_fromCodePointNode_;
    @Node.Child
    private InteropLibrary fallback_interop_;

    private ImportValueNodeGen() {
    }

    private boolean fallbackGuard_(int state_0, Object arg0Value) {
        TruffleObject arg0Value_;
        if ((state_0 & 2) == 0 && arg0Value instanceof String) {
            return false;
        }
        if ((state_0 & 4) == 0 && arg0Value instanceof TruffleString) {
            return false;
        }
        if ((state_0 & 8) == 0 && arg0Value instanceof Boolean) {
            return false;
        }
        if ((state_0 & 0x10) == 0 && arg0Value instanceof BigInt) {
            return false;
        }
        if (arg0Value instanceof Long) {
            long arg0Value_2 = (Long)arg0Value;
            if (JSGuards.isLongRepresentableAsInt32(arg0Value_2)) {
                return false;
            }
            arg0Value_2 = (Long)arg0Value;
            if (!JSGuards.isLongRepresentableAsInt32(arg0Value_2)) {
                return false;
            }
        }
        if (JSTypesGen.isImplicitDouble(arg0Value)) {
            return false;
        }
        if ((state_0 & 0x100) == 0 && arg0Value instanceof Byte) {
            return false;
        }
        if ((state_0 & 0x200) == 0 && arg0Value instanceof Short) {
            return false;
        }
        if ((state_0 & 0x400) == 0 && arg0Value instanceof Float) {
            return false;
        }
        if ((state_0 & 0x800) == 0 && arg0Value instanceof Character) {
            return false;
        }
        if ((state_0 & 0x1000) == 0 && arg0Value instanceof JSDynamicObject) {
            return false;
        }
        if ((state_0 & 0x2000) == 0 && arg0Value instanceof InteropFunction) {
            return false;
        }
        if ((state_0 & 0x4000) == 0 && arg0Value instanceof JSException) {
            return false;
        }
        if ((state_0 & 0x8000) == 0 && arg0Value instanceof UserScriptException) {
            return false;
        }
        return !(arg0Value instanceof TruffleObject) || ImportValueNode.isSpecial(arg0Value_ = (TruffleObject)arg0Value);
    }

    @Override
    public Object executeWithTarget(Object arg0Value) {
        int state_0 = this.state_0_;
        if ((state_0 & 0x3FFFF) != 0) {
            TruffleString.SwitchEncodingNode switchEncodingNode_1;
            InteropLibrary interop__;
            TruffleObject arg0Value_;
            Object arg0Value_2;
            if ((state_0 & 1) != 0 && arg0Value instanceof Integer) {
                int arg0Value_3 = (Integer)arg0Value;
                return ImportValueNode.fromInt(arg0Value_3);
            }
            if ((state_0 & 2) != 0 && arg0Value instanceof String) {
                arg0Value_2 = (String)arg0Value;
                TruffleString.FromJavaStringNode fromJavaStringNode__ = this.fromString_fromJavaStringNode_;
                if (fromJavaStringNode__ != null) {
                    return ImportValueNode.fromString((String)arg0Value_2, fromJavaStringNode__);
                }
            }
            if ((state_0 & 4) != 0 && arg0Value instanceof TruffleString) {
                arg0Value_2 = (TruffleString)arg0Value;
                TruffleString.SwitchEncodingNode switchEncodingNode_ = this.switchEncodingNode;
                if (switchEncodingNode_ != null) {
                    return ImportValueNode.fromTruffleString((TruffleString)arg0Value_2, switchEncodingNode_);
                }
            }
            if ((state_0 & 8) != 0 && arg0Value instanceof Boolean) {
                boolean arg0Value_4 = (Boolean)arg0Value;
                return ImportValueNode.fromBoolean(arg0Value_4);
            }
            if ((state_0 & 0x10) != 0 && arg0Value instanceof BigInt) {
                arg0Value_2 = (BigInt)arg0Value;
                return ImportValueNode.fromBigInt((BigInt)arg0Value_2);
            }
            if ((state_0 & 0x60) != 0 && arg0Value instanceof Long) {
                long arg0Value_5 = (Long)arg0Value;
                if ((state_0 & 0x20) != 0 && JSGuards.isLongRepresentableAsInt32(arg0Value_5)) {
                    return ImportValueNode.fromLongToInt(arg0Value_5);
                }
                if ((state_0 & 0x40) != 0 && !JSGuards.isLongRepresentableAsInt32(arg0Value_5)) {
                    return ImportValueNode.fromLong(arg0Value_5);
                }
            }
            if ((state_0 & 0x80) != 0 && JSTypesGen.isImplicitDouble((state_0 & 0x1C0000) >>> 18, arg0Value)) {
                double arg0Value_6 = JSTypesGen.asImplicitDouble((state_0 & 0x1C0000) >>> 18, arg0Value);
                return ImportValueNode.fromDouble(arg0Value_6);
            }
            if ((state_0 & 0x100) != 0 && arg0Value instanceof Byte) {
                byte arg0Value_7 = (Byte)arg0Value;
                return ImportValueNode.fromNumber(arg0Value_7);
            }
            if ((state_0 & 0x200) != 0 && arg0Value instanceof Short) {
                short arg0Value_8 = (Short)arg0Value;
                return ImportValueNode.fromNumber(arg0Value_8);
            }
            if ((state_0 & 0x400) != 0 && arg0Value instanceof Float) {
                float arg0Value_9 = ((Float)arg0Value).floatValue();
                return ImportValueNode.fromNumber(arg0Value_9);
            }
            if ((state_0 & 0x800) != 0 && arg0Value instanceof Character) {
                char arg0Value_10 = ((Character)arg0Value).charValue();
                TruffleString.FromCodePointNode fromCodePointNode__ = this.fromChar_fromCodePointNode_;
                if (fromCodePointNode__ != null) {
                    return ImportValueNode.fromChar(arg0Value_10, fromCodePointNode__);
                }
            }
            if ((state_0 & 0x1000) != 0 && arg0Value instanceof JSDynamicObject) {
                JSDynamicObject arg0Value_11 = (JSDynamicObject)((Object)arg0Value);
                return ImportValueNode.fromDynamicObject(arg0Value_11);
            }
            if ((state_0 & 0x2000) != 0 && arg0Value instanceof InteropFunction) {
                InteropFunction arg0Value_12 = (InteropFunction)arg0Value;
                return ImportValueNode.fromInteropFunction(arg0Value_12);
            }
            if ((state_0 & 0x4000) != 0 && arg0Value instanceof JSException) {
                JSException arg0Value_13 = (JSException)((Object)arg0Value);
                return ImportValueNode.fromJSException(arg0Value_13);
            }
            if ((state_0 & 0x8000) != 0 && arg0Value instanceof UserScriptException) {
                UserScriptException arg0Value_14 = (UserScriptException)((Object)arg0Value);
                return ImportValueNode.fromException(arg0Value_14);
            }
            if ((state_0 & 0x10000) != 0 && arg0Value instanceof TruffleObject && !ImportValueNode.isSpecial(arg0Value_ = (TruffleObject)arg0Value)) {
                return ImportValueNode.fromTruffleObject(arg0Value_);
            }
            if ((state_0 & 0x20000) != 0 && (interop__ = this.fallback_interop_) != null && (switchEncodingNode_1 = this.switchEncodingNode) != null && this.fallbackGuard_(state_0, arg0Value)) {
                return ImportValueNode.fallbackCase(arg0Value, interop__, switchEncodingNode_1);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value);
    }

    private Object executeAndSpecialize(Object arg0Value) {
        TruffleString.SwitchEncodingNode switchEncodingNode_1;
        TruffleObject truffleObject;
        int n;
        int state_0 = this.state_0_;
        if (arg0Value instanceof Integer) {
            int n2 = (Integer)arg0Value;
            this.state_0_ = state_0 |= 1;
            return ImportValueNode.fromInt(n2);
        }
        if (arg0Value instanceof String) {
            String string = (String)arg0Value;
            TruffleString.FromJavaStringNode fromJavaStringNode__ = (TruffleString.FromJavaStringNode)this.insert((Node)TruffleString.FromJavaStringNode.create());
            Objects.requireNonNull(fromJavaStringNode__, "Specialization 'fromString(String, FromJavaStringNode)' cache 'fromJavaStringNode' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
            VarHandle.storeStoreFence();
            this.fromString_fromJavaStringNode_ = fromJavaStringNode__;
            this.state_0_ = state_0 |= 2;
            return ImportValueNode.fromString(string, fromJavaStringNode__);
        }
        if (arg0Value instanceof TruffleString) {
            TruffleString.SwitchEncodingNode switchEncodingNode_;
            TruffleString truffleString = (TruffleString)arg0Value;
            TruffleString.SwitchEncodingNode switchEncodingNode__shared = this.switchEncodingNode;
            if (switchEncodingNode__shared != null) {
                switchEncodingNode_ = switchEncodingNode__shared;
            } else {
                switchEncodingNode_ = (TruffleString.SwitchEncodingNode)this.insert((Node)TruffleString.SwitchEncodingNode.create());
                if (switchEncodingNode_ == null) {
                    throw new IllegalStateException("Specialization 'fromTruffleString(TruffleString, SwitchEncodingNode)' contains a shared cache with name 'switchEncodingNode' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                }
            }
            if (this.switchEncodingNode == null) {
                VarHandle.storeStoreFence();
                this.switchEncodingNode = switchEncodingNode_;
            }
            this.state_0_ = state_0 |= 4;
            return ImportValueNode.fromTruffleString(truffleString, switchEncodingNode_);
        }
        if (arg0Value instanceof Boolean) {
            boolean bl = (Boolean)arg0Value;
            this.state_0_ = state_0 |= 8;
            return ImportValueNode.fromBoolean(bl);
        }
        if (arg0Value instanceof BigInt) {
            BigInt bigInt = (BigInt)arg0Value;
            this.state_0_ = state_0 |= 0x10;
            return ImportValueNode.fromBigInt(bigInt);
        }
        if (arg0Value instanceof Long) {
            long l = (Long)arg0Value;
            if (JSGuards.isLongRepresentableAsInt32(l)) {
                this.state_0_ = state_0 |= 0x20;
                return ImportValueNode.fromLongToInt(l);
            }
            if (!JSGuards.isLongRepresentableAsInt32(l)) {
                this.state_0_ = state_0 |= 0x40;
                return ImportValueNode.fromLong(l);
            }
        }
        if ((n = JSTypesGen.specializeImplicitDouble(arg0Value)) != 0) {
            double arg0Value_9 = JSTypesGen.asImplicitDouble(n, arg0Value);
            state_0 |= n << 18;
            this.state_0_ = state_0 |= 0x80;
            return ImportValueNode.fromDouble(arg0Value_9);
        }
        if (arg0Value instanceof Byte) {
            byte by = (Byte)arg0Value;
            this.state_0_ = state_0 |= 0x100;
            return ImportValueNode.fromNumber(by);
        }
        if (arg0Value instanceof Short) {
            short s = (Short)arg0Value;
            this.state_0_ = state_0 |= 0x200;
            return ImportValueNode.fromNumber(s);
        }
        if (arg0Value instanceof Float) {
            float f = ((Float)arg0Value).floatValue();
            this.state_0_ = state_0 |= 0x400;
            return ImportValueNode.fromNumber(f);
        }
        if (arg0Value instanceof Character) {
            char c = ((Character)arg0Value).charValue();
            TruffleString.FromCodePointNode fromCodePointNode__ = (TruffleString.FromCodePointNode)this.insert((Node)TruffleString.FromCodePointNode.create());
            Objects.requireNonNull(fromCodePointNode__, "Specialization 'fromChar(char, FromCodePointNode)' cache 'fromCodePointNode' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
            VarHandle.storeStoreFence();
            this.fromChar_fromCodePointNode_ = fromCodePointNode__;
            this.state_0_ = state_0 |= 0x800;
            return ImportValueNode.fromChar(c, fromCodePointNode__);
        }
        if (arg0Value instanceof JSDynamicObject) {
            JSDynamicObject jSDynamicObject = (JSDynamicObject)((Object)arg0Value);
            this.state_0_ = state_0 |= 0x1000;
            return ImportValueNode.fromDynamicObject(jSDynamicObject);
        }
        if (arg0Value instanceof InteropFunction) {
            InteropFunction interopFunction = (InteropFunction)arg0Value;
            this.state_0_ = state_0 |= 0x2000;
            return ImportValueNode.fromInteropFunction(interopFunction);
        }
        if (arg0Value instanceof JSException) {
            JSException jSException = (JSException)((Object)arg0Value);
            this.state_0_ = state_0 |= 0x4000;
            return ImportValueNode.fromJSException(jSException);
        }
        if (arg0Value instanceof UserScriptException) {
            UserScriptException userScriptException = (UserScriptException)((Object)arg0Value);
            this.state_0_ = state_0 |= 0x8000;
            return ImportValueNode.fromException(userScriptException);
        }
        if (arg0Value instanceof TruffleObject && !ImportValueNode.isSpecial(truffleObject = (TruffleObject)arg0Value)) {
            this.state_0_ = state_0 |= 0x10000;
            return ImportValueNode.fromTruffleObject(truffleObject);
        }
        InteropLibrary interopLibrary = (InteropLibrary)this.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.createDispatched(5)));
        Objects.requireNonNull(interopLibrary, "Specialization 'fallbackCase(Object, InteropLibrary, SwitchEncodingNode)' cache 'interop' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
        VarHandle.storeStoreFence();
        this.fallback_interop_ = interopLibrary;
        TruffleString.SwitchEncodingNode switchEncodingNode_1_shared = this.switchEncodingNode;
        if (switchEncodingNode_1_shared != null) {
            switchEncodingNode_1 = switchEncodingNode_1_shared;
        } else {
            switchEncodingNode_1 = (TruffleString.SwitchEncodingNode)this.insert((Node)TruffleString.SwitchEncodingNode.create());
            if (switchEncodingNode_1 == null) {
                throw new IllegalStateException("Specialization 'fallbackCase(Object, InteropLibrary, SwitchEncodingNode)' contains a shared cache with name 'switchEncodingNode' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
            }
        }
        if (this.switchEncodingNode == null) {
            VarHandle.storeStoreFence();
            this.switchEncodingNode = switchEncodingNode_1;
        }
        this.state_0_ = state_0 |= 0x20000;
        return ImportValueNode.fallbackCase(arg0Value, interopLibrary, switchEncodingNode_1);
    }

    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if ((state_0 & 0x3FFFF) == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state_0 & 0x3FFFF & (state_0 & 0x3FFFF) - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public Introspection getIntrospectionData() {
        TruffleString.SwitchEncodingNode switchEncodingNode_1;
        InteropLibrary interop__;
        TruffleString.FromCodePointNode fromCodePointNode__;
        TruffleString.SwitchEncodingNode switchEncodingNode_;
        ArrayList<List<Object>> cached;
        TruffleString.FromJavaStringNode fromJavaStringNode__;
        Object[] data = new Object[19];
        data[0] = 0;
        int state_0 = this.state_0_;
        Object[] s = new Object[3];
        s[0] = "fromInt";
        if ((state_0 & 1) != 0) {
            s[1] = (byte)1;
        }
        if (s[1] == null) {
            s[1] = (byte)0;
        }
        data[1] = s;
        s = new Object[3];
        s[0] = "fromString";
        if ((state_0 & 2) != 0 && (fromJavaStringNode__ = this.fromString_fromJavaStringNode_) != null) {
            s[1] = (byte)1;
            cached = new ArrayList<List<Object>>();
            cached.add(Arrays.asList(this.fromString_fromJavaStringNode_));
            s[2] = cached;
        }
        if (s[1] == null) {
            s[1] = (byte)0;
        }
        data[2] = s;
        s = new Object[3];
        s[0] = "fromTruffleString";
        if ((state_0 & 4) != 0 && (switchEncodingNode_ = this.switchEncodingNode) != null) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(this.switchEncodingNode));
            s[2] = cached;
        }
        if (s[1] == null) {
            s[1] = (byte)0;
        }
        data[3] = s;
        s = new Object[3];
        s[0] = "fromBoolean";
        if ((state_0 & 8) != 0) {
            s[1] = (byte)1;
        }
        if (s[1] == null) {
            s[1] = (byte)0;
        }
        data[4] = s;
        s = new Object[3];
        s[0] = "fromBigInt";
        if ((state_0 & 0x10) != 0) {
            s[1] = (byte)1;
        }
        if (s[1] == null) {
            s[1] = (byte)0;
        }
        data[5] = s;
        s = new Object[3];
        s[0] = "fromLongToInt";
        if ((state_0 & 0x20) != 0) {
            s[1] = (byte)1;
        }
        if (s[1] == null) {
            s[1] = (byte)0;
        }
        data[6] = s;
        s = new Object[3];
        s[0] = "fromLong";
        if ((state_0 & 0x40) != 0) {
            s[1] = (byte)1;
        }
        if (s[1] == null) {
            s[1] = (byte)0;
        }
        data[7] = s;
        s = new Object[3];
        s[0] = "fromDouble";
        if ((state_0 & 0x80) != 0) {
            s[1] = (byte)1;
        }
        if (s[1] == null) {
            s[1] = (byte)0;
        }
        data[8] = s;
        s = new Object[3];
        s[0] = "fromNumber";
        if ((state_0 & 0x100) != 0) {
            s[1] = (byte)1;
        }
        if (s[1] == null) {
            s[1] = (byte)0;
        }
        data[9] = s;
        s = new Object[3];
        s[0] = "fromNumber";
        if ((state_0 & 0x200) != 0) {
            s[1] = (byte)1;
        }
        if (s[1] == null) {
            s[1] = (byte)0;
        }
        data[10] = s;
        s = new Object[3];
        s[0] = "fromNumber";
        if ((state_0 & 0x400) != 0) {
            s[1] = (byte)1;
        }
        if (s[1] == null) {
            s[1] = (byte)0;
        }
        data[11] = s;
        s = new Object[3];
        s[0] = "fromChar";
        if ((state_0 & 0x800) != 0 && (fromCodePointNode__ = this.fromChar_fromCodePointNode_) != null) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(this.fromChar_fromCodePointNode_));
            s[2] = cached;
        }
        if (s[1] == null) {
            s[1] = (byte)0;
        }
        data[12] = s;
        s = new Object[3];
        s[0] = "fromDynamicObject";
        if ((state_0 & 0x1000) != 0) {
            s[1] = (byte)1;
        }
        if (s[1] == null) {
            s[1] = (byte)0;
        }
        data[13] = s;
        s = new Object[3];
        s[0] = "fromInteropFunction";
        if ((state_0 & 0x2000) != 0) {
            s[1] = (byte)1;
        }
        if (s[1] == null) {
            s[1] = (byte)0;
        }
        data[14] = s;
        s = new Object[3];
        s[0] = "fromJSException";
        if ((state_0 & 0x4000) != 0) {
            s[1] = (byte)1;
        }
        if (s[1] == null) {
            s[1] = (byte)0;
        }
        data[15] = s;
        s = new Object[3];
        s[0] = "fromException";
        if ((state_0 & 0x8000) != 0) {
            s[1] = (byte)1;
        }
        if (s[1] == null) {
            s[1] = (byte)0;
        }
        data[16] = s;
        s = new Object[3];
        s[0] = "fromTruffleObject";
        if ((state_0 & 0x10000) != 0) {
            s[1] = (byte)1;
        }
        if (s[1] == null) {
            s[1] = (byte)0;
        }
        data[17] = s;
        s = new Object[3];
        s[0] = "fallbackCase";
        if ((state_0 & 0x20000) != 0 && (interop__ = this.fallback_interop_) != null && (switchEncodingNode_1 = this.switchEncodingNode) != null) {
            s[1] = (byte)1;
            ArrayList<List<Object>> cached2 = new ArrayList<List<Object>>();
            cached2.add(Arrays.asList(this.fallback_interop_, this.switchEncodingNode));
            s[2] = cached2;
        }
        if (s[1] == null) {
            s[1] = (byte)0;
        }
        data[18] = s;
        return Introspection.Provider.create((Object[])data);
    }

    @NeverDefault
    public static ImportValueNode create() {
        return new ImportValueNodeGen();
    }

    @NeverDefault
    public static ImportValueNode getUncached() {
        return UNCACHED;
    }

    @GeneratedBy(value=ImportValueNode.class)
    @DenyReplace
    private static final class Uncached
    extends ImportValueNode {
        private Uncached() {
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object executeWithTarget(Object arg0Value) {
            TruffleObject arg0Value_;
            if (arg0Value instanceof Integer) {
                int arg0Value_2 = (Integer)arg0Value;
                return ImportValueNode.fromInt(arg0Value_2);
            }
            if (arg0Value instanceof String) {
                String arg0Value_3 = (String)arg0Value;
                return ImportValueNode.fromString(arg0Value_3, TruffleString.FromJavaStringNode.getUncached());
            }
            if (arg0Value instanceof TruffleString) {
                TruffleString arg0Value_4 = (TruffleString)arg0Value;
                return ImportValueNode.fromTruffleString(arg0Value_4, TruffleString.SwitchEncodingNode.getUncached());
            }
            if (arg0Value instanceof Boolean) {
                boolean arg0Value_5 = (Boolean)arg0Value;
                return ImportValueNode.fromBoolean(arg0Value_5);
            }
            if (arg0Value instanceof BigInt) {
                BigInt arg0Value_6 = (BigInt)arg0Value;
                return ImportValueNode.fromBigInt(arg0Value_6);
            }
            if (arg0Value instanceof Long) {
                long arg0Value_7 = (Long)arg0Value;
                if (JSGuards.isLongRepresentableAsInt32(arg0Value_7)) {
                    return ImportValueNode.fromLongToInt(arg0Value_7);
                }
                if (!JSGuards.isLongRepresentableAsInt32(arg0Value_7)) {
                    return ImportValueNode.fromLong(arg0Value_7);
                }
            }
            if (JSTypesGen.isImplicitDouble(arg0Value)) {
                double arg0Value_8 = JSTypesGen.asImplicitDouble(arg0Value);
                return ImportValueNode.fromDouble(arg0Value_8);
            }
            if (arg0Value instanceof Byte) {
                byte arg0Value_9 = (Byte)arg0Value;
                return ImportValueNode.fromNumber(arg0Value_9);
            }
            if (arg0Value instanceof Short) {
                short arg0Value_10 = (Short)arg0Value;
                return ImportValueNode.fromNumber(arg0Value_10);
            }
            if (arg0Value instanceof Float) {
                float arg0Value_11 = ((Float)arg0Value).floatValue();
                return ImportValueNode.fromNumber(arg0Value_11);
            }
            if (arg0Value instanceof Character) {
                char arg0Value_12 = ((Character)arg0Value).charValue();
                return ImportValueNode.fromChar(arg0Value_12, TruffleString.FromCodePointNode.getUncached());
            }
            if (arg0Value instanceof JSDynamicObject) {
                JSDynamicObject arg0Value_13 = (JSDynamicObject)((Object)arg0Value);
                return ImportValueNode.fromDynamicObject(arg0Value_13);
            }
            if (arg0Value instanceof InteropFunction) {
                InteropFunction arg0Value_14 = (InteropFunction)arg0Value;
                return ImportValueNode.fromInteropFunction(arg0Value_14);
            }
            if (arg0Value instanceof JSException) {
                JSException arg0Value_15 = (JSException)((Object)arg0Value);
                return ImportValueNode.fromJSException(arg0Value_15);
            }
            if (arg0Value instanceof UserScriptException) {
                UserScriptException arg0Value_16 = (UserScriptException)((Object)arg0Value);
                return ImportValueNode.fromException(arg0Value_16);
            }
            if (arg0Value instanceof TruffleObject && !ImportValueNode.isSpecial(arg0Value_ = (TruffleObject)arg0Value)) {
                return ImportValueNode.fromTruffleObject(arg0Value_);
            }
            return ImportValueNode.fallbackCase(arg0Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(), TruffleString.SwitchEncodingNode.getUncached());
        }

        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        public boolean isAdoptable() {
            return false;
        }
    }
}

