/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.v1.model.typedef;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.atlas.model.typedef.AtlasBaseTypeDef;
import org.apache.atlas.v1.model.typedef.ClassTypeDefinition;
import org.apache.atlas.v1.model.typedef.EnumTypeDefinition;
import org.apache.atlas.v1.model.typedef.StructTypeDefinition;
import org.apache.atlas.v1.model.typedef.TraitTypeDefinition;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonSerialize(include=JsonSerialize.Inclusion.ALWAYS)
@JsonIgnoreProperties(ignoreUnknown=true)
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class TypesDef
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<EnumTypeDefinition> enumTypes;
    private List<StructTypeDefinition> structTypes;
    private List<TraitTypeDefinition> traitTypes;
    private List<ClassTypeDefinition> classTypes;

    public TypesDef() {
    }

    public TypesDef(List<EnumTypeDefinition> enumTypes, List<StructTypeDefinition> structTypes, List<TraitTypeDefinition> traitTypes, List<ClassTypeDefinition> classTypes) {
        this.enumTypes = enumTypes;
        this.structTypes = structTypes;
        this.traitTypes = traitTypes;
        this.classTypes = classTypes;
    }

    public List<EnumTypeDefinition> getEnumTypes() {
        return this.enumTypes;
    }

    public void setEnumTypes(List<EnumTypeDefinition> enumTypes) {
        this.enumTypes = enumTypes;
    }

    public List<StructTypeDefinition> getStructTypes() {
        return this.structTypes;
    }

    public void setStructTypes(List<StructTypeDefinition> structTypes) {
        this.structTypes = structTypes;
    }

    public List<TraitTypeDefinition> getTraitTypes() {
        return this.traitTypes;
    }

    public void setTraitTypes(List<TraitTypeDefinition> traitTypes) {
        this.traitTypes = traitTypes;
    }

    public List<ClassTypeDefinition> getClassTypes() {
        return this.classTypes;
    }

    public void setClassTypes(List<ClassTypeDefinition> classTypes) {
        this.classTypes = classTypes;
    }

    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }

    public StringBuilder toString(StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        sb.append("TypesDef{");
        sb.append("enumTypes=[");
        AtlasBaseTypeDef.dumpObjects(this.enumTypes, sb);
        sb.append("], structTypes=[");
        AtlasBaseTypeDef.dumpObjects(this.structTypes, sb);
        sb.append("], traitTypes=[");
        AtlasBaseTypeDef.dumpObjects(this.traitTypes, sb);
        sb.append("], classTypes=[");
        AtlasBaseTypeDef.dumpObjects(this.classTypes, sb);
        sb.append("]");
        sb.append("}");
        return sb;
    }
}

