/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest.responses;

import java.io.IOException;
import java.util.stream.Collectors;
import org.apache.hive.iceberg.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.hive.iceberg.com.fasterxml.jackson.databind.JsonNode;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.rest.Endpoint;
import org.apache.iceberg.rest.responses.ConfigResponse;
import org.apache.iceberg.util.JsonUtil;

public class ConfigResponseParser {
    private static final String DEFAULTS = "defaults";
    private static final String OVERRIDES = "overrides";
    private static final String ENDPOINTS = "endpoints";

    private ConfigResponseParser() {
    }

    public static String toJson(ConfigResponse response) {
        return ConfigResponseParser.toJson(response, false);
    }

    public static String toJson(ConfigResponse response, boolean pretty) {
        return JsonUtil.generate(gen -> ConfigResponseParser.toJson(response, gen), pretty);
    }

    public static void toJson(ConfigResponse response, JsonGenerator gen) throws IOException {
        Preconditions.checkArgument(null != response, "Invalid config response: null");
        gen.writeStartObject();
        JsonUtil.writeStringMap(DEFAULTS, response.defaults(), gen);
        JsonUtil.writeStringMap(OVERRIDES, response.overrides(), gen);
        if (!response.endpoints().isEmpty()) {
            JsonUtil.writeStringArray(ENDPOINTS, response.endpoints().stream().map(Endpoint::toString).collect(Collectors.toList()), gen);
        }
        gen.writeEndObject();
    }

    public static ConfigResponse fromJson(String json) {
        return JsonUtil.parse(json, ConfigResponseParser::fromJson);
    }

    public static ConfigResponse fromJson(JsonNode json) {
        Preconditions.checkArgument(null != json, "Cannot parse config response from null object");
        ConfigResponse.Builder builder = ConfigResponse.builder();
        if (json.hasNonNull(DEFAULTS)) {
            builder.withDefaults(JsonUtil.getStringMapNullableValues(DEFAULTS, json));
        }
        if (json.hasNonNull(OVERRIDES)) {
            builder.withOverrides(JsonUtil.getStringMapNullableValues(OVERRIDES, json));
        }
        if (json.hasNonNull(ENDPOINTS)) {
            builder.withEndpoints(JsonUtil.getStringList(ENDPOINTS, json).stream().map(Endpoint::fromString).collect(Collectors.toList()));
        }
        return builder.build();
    }
}

