/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.parquet;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.hadoop.hive.common.io.encoded.MemoryBuffer;
import org.apache.hadoop.hive.common.io.encoded.MemoryBufferOrBuffers;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.io.SeekableInputStream;

public final class ParquetFooterInputFromCache
extends SeekableInputStream
implements InputFile {
    public static final int FOOTER_LENGTH_SIZE = 4;
    private static final int TAIL_LENGTH = ParquetFileWriter.MAGIC.length + 4;
    private static final int FAKE_PREFIX_LENGTH = ParquetFileWriter.MAGIC.length;
    private final int length;
    private final int footerLength;
    private int position = 0;
    private int bufferIx = 0;
    private int bufferPos = 0;
    private final MemoryBuffer[] cacheData;
    private final int[] positions;

    public ParquetFooterInputFromCache(MemoryBufferOrBuffers footerData) {
        MemoryBuffer oneBuffer = footerData.getSingleBuffer();
        if (oneBuffer != null) {
            this.cacheData = new MemoryBuffer[2];
            this.cacheData[0] = oneBuffer;
        } else {
            MemoryBuffer[] bufs = footerData.getMultipleBuffers();
            this.cacheData = new MemoryBuffer[bufs.length + 1];
            System.arraycopy(bufs, 0, this.cacheData, 0, bufs.length);
        }
        int footerLen = 0;
        this.positions = new int[this.cacheData.length];
        for (int i = 0; i < this.cacheData.length - 1; ++i) {
            this.positions[i] = footerLen;
            int dataLen = this.cacheData[i].getByteBufferRaw().remaining();
            assert (dataLen > 0);
            footerLen += dataLen;
        }
        this.positions[this.cacheData.length - 1] = footerLen;
        this.cacheData[this.cacheData.length - 1] = new FooterEndBuffer(footerLen);
        this.footerLength = footerLen;
        this.length = footerLen + FAKE_PREFIX_LENGTH + TAIL_LENGTH;
    }

    @Override
    public long getLength() throws IOException {
        return this.length;
    }

    @Override
    public SeekableInputStream newStream() throws IOException {
        return this;
    }

    @Override
    public long getPos() throws IOException {
        return this.position;
    }

    @Override
    public void seek(long pos) throws IOException {
        this.position = (int)pos;
        long targetPos = pos - (long)FAKE_PREFIX_LENGTH;
        for (int i = 1; i <= this.positions.length; ++i) {
            int endPos;
            int n = endPos = i == this.positions.length ? this.length - FAKE_PREFIX_LENGTH : this.positions[i];
            if ((long)endPos <= targetPos) continue;
            this.bufferIx = i - 1;
            this.bufferPos = (int)(targetPos - (long)this.positions[i - 1]);
            return;
        }
        throw new IOException("Incorrect seek " + targetPos + "; footer length " + this.footerLength + Arrays.toString(this.positions));
    }

    @Override
    public void readFully(byte[] b, int offset, int len) throws IOException {
        if (this.readInternal(b, offset, len) == len) {
            return;
        }
        throw new EOFException();
    }

    public int readInternal(byte[] bytes, int offset, int len) {
        int toConsume;
        if (this.position >= this.length) {
            return -1;
        }
        int argEnd = offset + len;
        for (int argPos = offset; argPos < argEnd; argPos += toConsume) {
            if (this.bufferIx == this.cacheData.length) {
                return argPos - offset;
            }
            ByteBuffer data = this.cacheData[this.bufferIx].getByteBufferDup();
            toConsume = Math.min(argEnd - argPos, data.remaining() - this.bufferPos);
            data.position(data.position() + this.bufferPos);
            data.get(bytes, argPos, toConsume);
            if (data.remaining() == 0) {
                ++this.bufferIx;
                this.bufferPos = 0;
                continue;
            }
            this.bufferPos += toConsume;
        }
        return len;
    }

    @Override
    public int read() throws IOException {
        if (this.position >= this.length) {
            return -1;
        }
        ++this.position;
        ByteBuffer data = this.cacheData[this.bufferIx].getByteBufferRaw();
        int bp = this.bufferPos++;
        if (this.bufferPos == data.remaining()) {
            ++this.bufferIx;
            this.bufferPos = 0;
        }
        return data.get(data.position() + bp) & 0xFF;
    }

    @Override
    public int read(ByteBuffer bb) throws IOException {
        int result = -1;
        if (bb.hasArray()) {
            result = this.readInternal(bb.array(), bb.arrayOffset(), bb.remaining());
            if (result > 0) {
                bb.position(bb.position() + result);
            }
        } else {
            byte[] bytes = new byte[bb.remaining()];
            result = this.readInternal(bytes, 0, bb.remaining());
            bb.put(bytes, 0, result);
        }
        return result;
    }

    @Override
    public void readFully(byte[] arg0) throws IOException {
        this.readFully(arg0, 0, arg0.length);
    }

    @Override
    public void readFully(ByteBuffer arg0) throws IOException {
        this.read(arg0);
    }

    private static final class FooterEndBuffer
    implements MemoryBuffer {
        private final ByteBuffer bb;

        FooterEndBuffer(int footerLength) {
            byte[] bytes = new byte[8];
            bytes[0] = (byte)(footerLength >>> 0 & 0xFF);
            bytes[1] = (byte)(footerLength >>> 8 & 0xFF);
            bytes[2] = (byte)(footerLength >>> 16 & 0xFF);
            bytes[3] = (byte)(footerLength >>> 24 & 0xFF);
            for (int i = 0; i < ParquetFileWriter.MAGIC.length; ++i) {
                bytes[4 + i] = ParquetFileWriter.MAGIC[i];
            }
            this.bb = ByteBuffer.wrap(bytes);
        }

        public ByteBuffer getByteBufferRaw() {
            return this.bb;
        }

        public ByteBuffer getByteBufferDup() {
            return this.bb.duplicate();
        }
    }
}

