/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.IOException;
import java.util.Map;
import java.util.function.Function;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.avro.Avro;
import org.apache.iceberg.avro.InternalReader;
import org.apache.iceberg.avro.InternalWriter;
import org.apache.iceberg.common.DynMethods;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalData {
    private static final Logger LOG = LoggerFactory.getLogger(InternalData.class);
    private static final Map<FileFormat, Function<OutputFile, WriteBuilder>> WRITE_BUILDERS = Maps.newConcurrentMap();
    private static final Map<FileFormat, Function<InputFile, ReadBuilder>> READ_BUILDERS = Maps.newConcurrentMap();

    private InternalData() {
    }

    static void register(FileFormat format, Function<OutputFile, WriteBuilder> writeBuilder, Function<InputFile, ReadBuilder> readBuilder) {
        WRITE_BUILDERS.put(format, writeBuilder);
        READ_BUILDERS.put(format, readBuilder);
    }

    private static void registerSupportedFormats() {
        InternalData.register(FileFormat.AVRO, outputFile -> Avro.write(outputFile).createWriterFunc(InternalWriter::create), inputFile -> Avro.read(inputFile).createResolvingReader(InternalReader::create));
        try {
            DynMethods.StaticMethod registerParquet = DynMethods.builder("register").impl("org.apache.iceberg.InternalParquet", new Class[0]).buildStaticChecked();
            registerParquet.invoke(new Object[0]);
        }
        catch (NoSuchMethodException e) {
            LOG.info("Unable to register Parquet for metadata files: {}", (Object)e.getMessage());
        }
    }

    public static WriteBuilder write(FileFormat format, OutputFile file) {
        Function<OutputFile, WriteBuilder> writeBuilder = WRITE_BUILDERS.get((Object)format);
        if (writeBuilder != null) {
            return writeBuilder.apply(file);
        }
        throw new UnsupportedOperationException("Cannot write using unregistered internal data format: " + format);
    }

    public static ReadBuilder read(FileFormat format, InputFile file) {
        Function<InputFile, ReadBuilder> readBuilder = READ_BUILDERS.get((Object)format);
        if (readBuilder != null) {
            return readBuilder.apply(file);
        }
        throw new UnsupportedOperationException("Cannot read using unregistered internal data format: " + format);
    }

    static {
        InternalData.registerSupportedFormats();
    }

    public static interface ReadBuilder {
        public ReadBuilder project(Schema var1);

        public ReadBuilder split(long var1, long var3);

        public ReadBuilder reuseContainers();

        public ReadBuilder setRootType(Class<? extends StructLike> var1);

        public ReadBuilder setCustomType(int var1, Class<? extends StructLike> var2);

        public <D> CloseableIterable<D> build();
    }

    public static interface WriteBuilder {
        public WriteBuilder schema(Schema var1);

        public WriteBuilder named(String var1);

        public WriteBuilder set(String var1, String var2);

        public WriteBuilder meta(String var1, String var2);

        default public WriteBuilder meta(Map<String, String> properties) {
            properties.forEach(this::meta);
            return this;
        }

        public WriteBuilder overwrite();

        public <D> FileAppender<D> build() throws IOException;
    }
}

