/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn.compactor;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.CompactionType;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.txn.compactor.CompactionQueryBuilder;
import org.apache.hadoop.hive.ql.txn.compactor.CompactionQueryBuilderFactory;
import org.apache.hadoop.hive.ql.txn.compactor.CompactorContext;
import org.apache.hadoop.hive.ql.txn.compactor.QueryCompactor;

final class MajorQueryCompactor
extends QueryCompactor {
    MajorQueryCompactor() {
    }

    @Override
    public boolean run(CompactorContext context) throws IOException {
        HiveConf hiveConf = context.getConf();
        Table table = context.getTable();
        AcidUtils.setAcidOperationalProperties((Configuration)hiveConf, true, AcidUtils.getAcidOperationalProperties(table.getParameters()));
        StorageDescriptor storageDescriptor = context.getSd();
        ValidWriteIdList writeIds = context.getValidWriteIdList();
        HiveConf conf = this.setUpDriverSession(hiveConf);
        String tmpTableName = this.getTempTableName(table);
        Path tmpTablePath = QueryCompactor.Util.getCompactionResultDir(storageDescriptor, writeIds, conf, true, false, null);
        List<String> createQueries = this.getCreateQueries(tmpTableName, table, tmpTablePath.toString());
        List<String> compactionQueries = this.getCompactionQueries(table, context.getPartition(), tmpTableName);
        List<String> dropQueries = this.getDropQueries(tmpTableName);
        this.runCompactionQueries(conf, tmpTableName, context.getCompactionInfo(), Lists.newArrayList((Object[])new Path[]{tmpTablePath}), createQueries, compactionQueries, dropQueries, table.getParameters());
        return true;
    }

    @Override
    protected HiveConf setUpDriverSession(HiveConf hiveConf) {
        HiveConf conf = super.setUpDriverSession(hiveConf);
        conf.set(HiveConf.ConfVars.SPLIT_GROUPING_MODE.varname, "compactor");
        return conf;
    }

    private List<String> getCreateQueries(String fullName, Table t, String tmpTableLocation) {
        return Lists.newArrayList((Object[])new String[]{new CompactionQueryBuilderFactory().getCompactionQueryBuilder(CompactionType.MAJOR, false).setOperation(CompactionQueryBuilder.Operation.CREATE).setResultTableName(fullName).setSourceTab(t).setLocation(tmpTableLocation).build()});
    }

    private List<String> getCompactionQueries(Table t, Partition p, String tmpName) {
        return Lists.newArrayList((Object[])new String[]{new CompactionQueryBuilderFactory().getCompactionQueryBuilder(CompactionType.MAJOR, false).setOperation(CompactionQueryBuilder.Operation.INSERT).setResultTableName(tmpName).setSourceTab(t).setSourcePartition(p).build()});
    }

    private List<String> getDropQueries(String tmpTableName) {
        return Lists.newArrayList((Object[])new String[]{new CompactionQueryBuilderFactory().getCompactionQueryBuilder(CompactionType.MAJOR, false).setOperation(CompactionQueryBuilder.Operation.DROP).setResultTableName(tmpTableName).build()});
    }
}

