/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn.compactor;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hive.metastore.api.CompactionType;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.txn.compactor.CompactionQueryBuilder;

class CompactionQueryBuilderForRebalance
extends CompactionQueryBuilder {
    CompactionQueryBuilderForRebalance() {
        super(CompactionType.REBALANCE, false);
    }

    @Override
    protected void buildSelectClauseForInsert(StringBuilder query) {
        if (this.sourceTab != null) {
            List cols = this.sourceTab.getSd().getCols();
            query.append("0, t2.writeId, t2.rowId DIV CEIL(numRows / ").append(this.numberOfBuckets).append("), t2.rowId, t2.writeId, t2.data from (select ").append("count(ROW__ID.writeId) over() as numRows, ");
            if (StringUtils.isNotBlank((CharSequence)this.orderByClause)) {
                query.append("MAX(ROW__ID.writeId) over() as writeId, row_number() OVER (").append(this.orderByClause);
            } else {
                query.append("ROW__ID.writeId as writeId, row_number() OVER (order by ROW__ID.writeId ASC, ROW__ID.bucketId ASC, ROW__ID.rowId ASC");
            }
            query.append(") - 1 AS rowId, NAMED_STRUCT(");
            for (int i = 0; i < cols.size(); ++i) {
                query.append(i == 0 ? "'" : ", '").append(((FieldSchema)cols.get(i)).getName()).append("', `").append(((FieldSchema)cols.get(i)).getName()).append("`");
            }
            query.append(") as data");
        }
    }

    @Override
    protected void getSourceForInsert(StringBuilder query) {
        super.getSourceForInsert(query);
        if (StringUtils.isNotBlank((CharSequence)this.orderByClause)) {
            query.append(this.orderByClause);
        } else {
            query.append("order by ROW__ID.writeId ASC, ROW__ID.bucketId ASC, ROW__ID.rowId ASC");
        }
        query.append(") t2");
    }

    @Override
    protected void buildWhereClauseForInsert(StringBuilder query) {
    }
}

