/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.stats;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.plan.Statistics;
import org.apache.hadoop.hive.ql.stats.Partish;
import org.apache.hadoop.hive.ql.stats.StatsUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicStats {
    private static final Logger LOG = LoggerFactory.getLogger((String)BasicStats.class.getName());
    private Partish partish;
    private long rowCount;
    private long totalSize;
    private long rawDataSize;
    private long currentNumRows;
    private long currentDataSize;
    private long currentFileSize;
    private Statistics.State state;

    public BasicStats(Partish p) {
        this.partish = p;
        this.tryGetBasicStatsFromStorageHandler();
        this.rowCount = this.parseLong("numRows");
        this.rawDataSize = this.parseLong("rawDataSize");
        this.totalSize = this.parseLong("totalSize");
        this.currentNumRows = this.rowCount;
        this.currentDataSize = this.rawDataSize;
        this.currentFileSize = this.totalSize;
        this.state = this.currentNumRows > 0L ? Statistics.State.COMPLETE : Statistics.State.NONE;
    }

    public BasicStats(List<BasicStats> partStats) {
        this.partish = null;
        ArrayList nrIn = Lists.newArrayList();
        ArrayList dsIn = Lists.newArrayList();
        ArrayList fsIn = Lists.newArrayList();
        this.state = partStats.isEmpty() ? Statistics.State.COMPLETE : null;
        for (BasicStats ps : partStats) {
            nrIn.add(ps.getNumRows());
            dsIn.add(ps.getDataSize());
            fsIn.add(ps.getTotalFileSize());
            if (this.state == null) {
                this.state = ps.getState();
                continue;
            }
            this.state = this.state.merge(ps.getState());
        }
        this.currentNumRows = StatsUtils.getSumIgnoreNegatives(nrIn);
        this.currentDataSize = StatsUtils.getSumIgnoreNegatives(dsIn);
        this.currentFileSize = StatsUtils.getSumIgnoreNegatives(fsIn);
    }

    private void tryGetBasicStatsFromStorageHandler() {
        if (this.partish.getTable() != null && this.partish.getTable().isNonNative() && this.partish.getTable().getStorageHandler().canProvideBasicStatistics()) {
            this.partish.getPartParameters().putAll(this.partish.getTable().getStorageHandler().getBasicStatistics(this.partish));
        }
    }

    public long getNumRows() {
        return this.currentNumRows;
    }

    public long getDataSize() {
        return this.currentDataSize;
    }

    public Statistics.State getState() {
        return this.state;
    }

    void apply(IStatsEnhancer estimator) {
        estimator.apply(this);
    }

    protected void setNumRows(long l) {
        this.currentNumRows = l;
    }

    protected void setDataSize(long ds) {
        this.currentDataSize = ds;
    }

    protected long getTotalFileSize() {
        return this.currentFileSize;
    }

    public void setTotalFileSize(long totalFileSize) {
        this.currentFileSize = totalFileSize;
    }

    protected long getRawDataSize() {
        return this.rawDataSize;
    }

    private long parseLong(String fieldName) {
        String val;
        Map<String, String> params = this.partish.getPartParameters();
        long result = -1L;
        if (params != null && !StringUtils.isBlank((CharSequence)(val = params.get(fieldName)))) {
            try {
                result = Long.parseLong(val);
            }
            catch (NumberFormatException e) {
                LOG.warn("Error parsing {} value: {}", (Object)fieldName, (Object)val);
            }
        }
        return result;
    }

    public static BasicStats buildFrom(List<BasicStats> partStats) {
        return new BasicStats(partStats);
    }

    public String toString() {
        return String.format("BasicStats: %d, %d %s", new Object[]{this.getNumRows(), this.getDataSize(), this.getState()});
    }

    public static interface IStatsEnhancer {
        public void apply(BasicStats var1);
    }

    public static class DataSizeEstimator
    implements IStatsEnhancer {
        private HiveConf conf;
        private float deserFactor;

        public DataSizeEstimator(HiveConf conf) {
            this.conf = conf;
            this.deserFactor = HiveConf.getFloatVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_STATS_DESERIALIZATION_FACTOR);
        }

        @Override
        public void apply(BasicStats stats) {
            long ds = stats.getRawDataSize();
            if (ds <= 0L) {
                ds = stats.getTotalFileSize();
                if (ds <= 0L) {
                    Path path = stats.partish.getPath();
                    try {
                        ds = this.getFileSizeForPath(path);
                    }
                    catch (IOException e) {
                        ds = 0L;
                    }
                }
                ds = (long)((float)ds * this.deserFactor);
                stats.setDataSize(ds);
            }
        }

        private long getFileSizeForPath(Path path) throws IOException {
            FileSystem fs = path.getFileSystem((Configuration)this.conf);
            RemoteIterator it = fs.listFiles(path, true);
            long size = 0L;
            while (it.hasNext()) {
                size += ((LocatedFileStatus)it.next()).getLen();
            }
            return size;
        }
    }

    public static class RowNumEstimator
    implements IStatsEnhancer {
        private long avgRowSize;

        public RowNumEstimator(long avgRowSize) {
            this.avgRowSize = avgRowSize;
            if (avgRowSize > 0L && LOG.isDebugEnabled()) {
                LOG.debug("Estimated average row size: " + avgRowSize);
            }
        }

        @Override
        public void apply(BasicStats stats) {
            if (stats.partish.getPartition() == null) {
                if (stats.getNumRows() < 0L && this.avgRowSize > 0L) {
                    stats.setNumRows(stats.getDataSize() / this.avgRowSize);
                }
            } else if (this.avgRowSize > 0L) {
                long rc = stats.getNumRows();
                long s = stats.getDataSize();
                if (rc <= 0L && s > 0L) {
                    rc = s / this.avgRowSize;
                    stats.setNumRows(rc);
                }
                if (s <= 0L && rc > 0L) {
                    s = StatsUtils.safeMult(rc, this.avgRowSize);
                    stats.setDataSize(s);
                }
            }
            if (stats.getNumRows() > 0L && Statistics.State.PARTIAL.morePreciseThan(stats.state)) {
                stats.state = Statistics.State.PARTIAL;
            }
        }
    }

    public static class SetMinRowNumber
    implements IStatsEnhancer {
        @Override
        public void apply(BasicStats stats) {
            if (stats.getNumRows() == 0L || stats.getNumRows() == -1L) {
                stats.setNumRows(1L);
            }
        }
    }

    public static class Factory {
        private final List<IStatsEnhancer> enhancers = new LinkedList<IStatsEnhancer>();

        public Factory(IStatsEnhancer ... enhancers) {
            this.enhancers.addAll(Arrays.asList(enhancers));
        }

        public void addEnhancer(IStatsEnhancer enhancer) {
            this.enhancers.add(enhancer);
        }

        public BasicStats build(Partish p) {
            BasicStats ret = new BasicStats(p);
            for (IStatsEnhancer enhancer : this.enhancers) {
                ret.apply(enhancer);
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<BasicStats> buildAll(HiveConf conf, Collection<Partish> parts) {
            LOG.info("Number of partishes : " + parts.size());
            ArrayList<BasicStats> ret = new ArrayList<BasicStats>(parts.size());
            if (parts.size() <= 1) {
                for (Partish partish : parts) {
                    ret.add(this.build(partish));
                }
                return ret;
            }
            ArrayList<Future<BasicStats>> futures = new ArrayList<Future<BasicStats>>();
            int threads = conf.getIntVar(HiveConf.ConfVars.METASTORE_FS_HANDLER_THREADS_COUNT);
            Object pool = threads <= 1 ? MoreExecutors.newDirectExecutorService() : Executors.newFixedThreadPool(threads, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Get-Partitions-Size-%d").build());
            for (final Partish part : parts) {
                futures.add(pool.submit(new Callable<BasicStats>(){

                    @Override
                    public BasicStats call() throws Exception {
                        return this.build(part);
                    }
                }));
            }
            try {
                for (int i = 0; i < futures.size(); ++i) {
                    ret.add(i, (BasicStats)((Future)futures.get(i)).get());
                }
            }
            catch (InterruptedException | ExecutionException e) {
                LOG.warn("Exception in processing files ", (Throwable)e);
            }
            finally {
                pool.shutdownNow();
            }
            return ret;
        }
    }
}

