/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.rewrite;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.HiveStorageHandler;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.rewrite.CopyOnWriteUpdateRewriter;
import org.apache.hadoop.hive.ql.parse.rewrite.Rewriter;
import org.apache.hadoop.hive.ql.parse.rewrite.RewriterFactory;
import org.apache.hadoop.hive.ql.parse.rewrite.SplitUpdateRewriter;
import org.apache.hadoop.hive.ql.parse.rewrite.UpdateRewriter;
import org.apache.hadoop.hive.ql.parse.rewrite.UpdateStatement;
import org.apache.hadoop.hive.ql.parse.rewrite.sql.SqlGeneratorFactory;

public class UpdateRewriterFactory
implements RewriterFactory<UpdateStatement> {
    protected final HiveConf conf;

    public UpdateRewriterFactory(HiveConf conf) {
        this.conf = conf;
    }

    @Override
    public Rewriter<UpdateStatement> createRewriter(Table table, String targetTableFullName, String subQueryAlias) throws SemanticException {
        boolean splitUpdate = HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.SPLIT_UPDATE);
        boolean copyOnWriteMode = false;
        HiveStorageHandler storageHandler = table.getStorageHandler();
        if (storageHandler != null) {
            copyOnWriteMode = storageHandler.shouldOverwrite(table, Context.Operation.UPDATE);
        }
        SqlGeneratorFactory sqlGeneratorFactory = new SqlGeneratorFactory(table, targetTableFullName, this.conf, splitUpdate && !copyOnWriteMode ? "s" : null, "__d__");
        if (copyOnWriteMode) {
            return new CopyOnWriteUpdateRewriter(this.conf, sqlGeneratorFactory);
        }
        if (splitUpdate) {
            return new SplitUpdateRewriter(this.conf, sqlGeneratorFactory);
        }
        if (AcidUtils.isNonNativeAcidTable(table)) {
            throw new SemanticException(ErrorMsg.NON_NATIVE_ACID_UPDATE.getErrorCodedMsg());
        }
        return new UpdateRewriter(this.conf, sqlGeneratorFactory);
    }
}

