/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.rewrite;

import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.ParseUtils;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.rewrite.DeleteStatement;
import org.apache.hadoop.hive.ql.parse.rewrite.Rewriter;
import org.apache.hadoop.hive.ql.parse.rewrite.sql.MultiInsertSqlGenerator;
import org.apache.hadoop.hive.ql.parse.rewrite.sql.SqlGeneratorFactory;
import org.apache.hadoop.hive.ql.parse.rewrite.sql.WhereClausePatcher;

public class DeleteRewriter
implements Rewriter<DeleteStatement> {
    protected final SqlGeneratorFactory sqlGeneratorFactory;
    private final WhereClausePatcher whereClausePatcher;

    public DeleteRewriter(SqlGeneratorFactory sqlGeneratorFactory) {
        this.sqlGeneratorFactory = sqlGeneratorFactory;
        this.whereClausePatcher = new WhereClausePatcher();
    }

    @Override
    public ParseUtils.ReparseResult rewrite(Context context, DeleteStatement deleteBlock) throws SemanticException {
        MultiInsertSqlGenerator sqlGenerator = this.sqlGeneratorFactory.createSqlGenerator();
        sqlGenerator.append("insert into table ");
        sqlGenerator.append(sqlGenerator.getTargetTableFullName());
        sqlGenerator.appendPartitionColsOfTarget();
        sqlGenerator.append(" select ");
        sqlGenerator.appendAcidSelectColumns(Context.Operation.DELETE);
        sqlGenerator.removeLastChar();
        sqlGenerator.append(" from ");
        sqlGenerator.append(sqlGenerator.getTargetTableFullName());
        sqlGenerator.appendSortKeys();
        ParseUtils.ReparseResult rr = ParseUtils.parseRewrittenQuery(context, sqlGenerator.toString());
        Context rewrittenCtx = rr.rewrittenCtx;
        ASTNode rewrittenTree = rr.rewrittenTree;
        ASTNode rewrittenInsert = (ASTNode)rewrittenTree.getChildren().get(1);
        rewrittenCtx.setOperation(Context.Operation.DELETE);
        rewrittenCtx.addDestNamePrefix(1, Context.DestClausePrefix.DELETE);
        if (deleteBlock.getWhereTree() != null) {
            this.whereClausePatcher.patch(rewrittenInsert, deleteBlock.getWhereTree());
        }
        rewrittenCtx.setEnableUnparse(false);
        return rr;
    }
}

